/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.backend.lucene.RandomGenerator;
import org.hibernate.search.test.backend.lucene.Rating;

@Indexed
public class Quote {
    private static final RandomGenerator randomGenerator = RandomGenerator.withDefaults();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_RATINGS = 5;
    private List<Rating> ratings = new ArrayList<Rating>();
    @Field(store=Store.YES)
    private String description;
    @DocumentId
    private Integer id;

    public Quote(Integer id, String description) {
        this.description = description;
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    @IndexedEmbedded
    private List<Rating> getRatings() {
        return this.ratings;
    }

    public void addRating(Rating rating) {
        this.ratings.add(rating);
    }

    public static Quote random() {
        return Quote.getRandomQuote(null);
    }

    public static Quote random(int id) {
        return Quote.getRandomQuote(id);
    }

    private static Quote getRandomQuote(Integer id) {
        int docId = id == null ? counter.incrementAndGet() : id.intValue();
        Quote quote = new Quote(docId, randomGenerator.generateRandomPhrase());
        Quote.addRatings(quote);
        return quote;
    }

    private static void addRatings(Quote quote) {
        for (int i = 0; i < randomGenerator.randomIntNotZero(5); ++i) {
            quote.addRating(Rating.random());
        }
    }

    public String toString() {
        return "Quote{name='" + this.description + '\'' + ", id=" + this.id + ", ratings=" + this.ratings + '}';
    }
}

