/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.sort.impl;

import org.apache.lucene.search.SortField;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.sort.SortAdditionalSortFieldContext;
import org.hibernate.search.query.dsl.sort.SortDistanceNoFieldContext;
import org.hibernate.search.query.dsl.sort.SortFieldContext;
import org.hibernate.search.query.dsl.sort.SortNativeContext;
import org.hibernate.search.query.dsl.sort.SortOrderTermination;
import org.hibernate.search.query.dsl.sort.SortScoreContext;
import org.hibernate.search.query.dsl.sort.impl.AbstractConnectedSortContext;
import org.hibernate.search.query.dsl.sort.impl.ConnectedSortDistanceNoFieldContext;
import org.hibernate.search.query.dsl.sort.impl.ConnectedSortFieldContext;
import org.hibernate.search.query.dsl.sort.impl.ConnectedSortNativeContext;
import org.hibernate.search.query.dsl.sort.impl.ConnectedSortOrderTermination;
import org.hibernate.search.query.dsl.sort.impl.ConnectedSortScoreContext;
import org.hibernate.search.query.dsl.sort.impl.SortFieldStates;

public abstract class ConnectedSortAdditionalSortFieldContext
extends AbstractConnectedSortContext
implements SortAdditionalSortFieldContext {
    public ConnectedSortAdditionalSortFieldContext(QueryBuildingContext queryContext, SortFieldStates states) {
        super(queryContext, states);
    }

    @Override
    public SortFieldContext andByField(String field) {
        this.states.closeSortField();
        this.states.setCurrentName(field);
        this.states.determineCurrentSortFieldTypeAutomaticaly();
        return new ConnectedSortFieldContext(this.queryContext, this.states);
    }

    @Override
    public SortFieldContext andByField(String field, SortField.Type sortFieldType) {
        this.states.closeSortField();
        this.states.setCurrentName(field);
        this.states.setCurrentType(sortFieldType);
        return new ConnectedSortFieldContext(this.queryContext, this.states);
    }

    @Override
    public SortScoreContext andByScore() {
        this.states.closeSortField();
        this.states.setCurrentType(SortField.Type.SCORE);
        return new ConnectedSortScoreContext(this.queryContext, this.states);
    }

    @Override
    public SortOrderTermination andByIndexOrder() {
        this.states.closeSortField();
        this.states.setCurrentType(SortField.Type.DOC);
        return new ConnectedSortOrderTermination(this.queryContext, this.states);
    }

    @Override
    public SortDistanceNoFieldContext andByDistance() {
        this.states.closeSortField();
        return new ConnectedSortDistanceNoFieldContext(this.queryContext, this.states);
    }

    @Override
    public SortNativeContext andByNative(SortField sortField) {
        this.states.closeSortField();
        this.states.setCurrentSortFieldNativeSortDescription(sortField);
        return new ConnectedSortNativeContext(this.queryContext, this.states);
    }

    @Override
    public SortNativeContext andByNative(String sortField, String nativeDescription) {
        this.states.closeSortField();
        this.states.setCurrentName(sortField);
        this.states.setCurrentStringNativeSortFieldDescription(nativeDescription);
        return new ConnectedSortNativeContext(this.queryContext, this.states);
    }
}

