/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.OffsetDateTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OffsetDateTimeBridgeTest {
    private static final OffsetDateTimeBridge BRIDGE = OffsetDateTimeBridge.INSTANCE;
    private static final String MAX = "+9999999991231235959999999999+18:00";
    private static final String MIN = "-9999999990101000000000000000-18:00";
    private static final String CUSTOM = "-0000000010203040506000000007+08:00";
    private static final OffsetDateTime MAX_DATE_TIME = OffsetDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX);
    private static final OffsetDateTime MIN_DATE_TIME = OffsetDateTime.of(LocalDateTime.MIN, ZoneOffset.MIN);
    private static final OffsetDateTime CUSTOM_DATE_TIME = OffsetDateTime.of(LocalDate.of(-1, 2, 3), LocalTime.of(4, 5, 6, 7), ZoneOffset.ofHours(8));
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_DATE_TIME)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_DATE_TIME)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_DATE_TIME)).isEqualTo((Object)CUSTOM);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_DATE_TIME);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_DATE_TIME);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CUSTOM)).isEqualTo((Object)CUSTOM_DATE_TIME);
    }
}

