/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.commitpolicy;

import org.hibernate.search.backend.impl.CommitPolicy;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.PerChangeSetCommitPolicy;
import org.hibernate.search.backend.impl.lucene.ScheduledCommitPolicy;
import org.hibernate.search.backend.impl.lucene.SharedIndexCommitPolicy;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class CommitPolicyConfigurationTest {
    @Rule
    public SearchFactoryHolder sfSyncExclusiveIndex = new SearchFactoryHolder(A.class).withProperty("hibernate.search.default.exclusive_index_use", "true");
    @Rule
    public SearchFactoryHolder sfSyncSharedIndex = new SearchFactoryHolder(A.class).withProperty("hibernate.search.default.exclusive_index_use", "false");
    @Rule
    public SearchFactoryHolder sfAsyncSharedIndex = new SearchFactoryHolder(A.class).withProperty("hibernate.search.default.default.worker.execution", "async").withProperty("hibernate.search.default.exclusive_index_use", "false");
    @Rule
    public SearchFactoryHolder sfAsyncExclusiveIndex = new SearchFactoryHolder(A.class).withProperty("hibernate.search.default.worker.execution", "async").withProperty("hibernate.search.default.exclusive_index_use", "true");
    @Rule
    public SearchFactoryHolder sfAsyncExclusiveIndexCustomPeriod = new SearchFactoryHolder(A.class).withProperty("hibernate.search.default.index_flush_interval", "100").withProperty("hibernate.search.default.worker.execution", "async").withProperty("hibernate.search.default.exclusive_index_use", "true");

    @Test
    public void testConfiguredCommitPolicy() throws Exception {
        this.assertCommitPolicyUsed(this.sfSyncExclusiveIndex, PerChangeSetCommitPolicy.class);
        this.assertCommitPolicyUsed(this.sfSyncSharedIndex, SharedIndexCommitPolicy.class);
        this.assertCommitPolicyUsed(this.sfAsyncSharedIndex, SharedIndexCommitPolicy.class);
        this.assertCommitPolicyUsed(this.sfAsyncExclusiveIndex, ScheduledCommitPolicy.class);
    }

    @Test
    public void testDefaultValue() throws Exception {
        Assert.assertEquals((long)100L, (long)this.extractInterval(this.sfAsyncExclusiveIndexCustomPeriod));
        Assert.assertEquals((long)1000L, (long)this.extractInterval(this.sfAsyncExclusiveIndex));
    }

    private void assertCommitPolicyUsed(SearchFactoryHolder sfHolder, Class<? extends CommitPolicy> commitPolicyClass) {
        CommitPolicy commitPolicy = this.getCommitPolicy(sfHolder);
        Assert.assertTrue((boolean)commitPolicyClass.isAssignableFrom(commitPolicy.getClass()));
    }

    private int extractInterval(SearchFactoryHolder sfHolder) {
        ScheduledCommitPolicy commitPolicy = (ScheduledCommitPolicy)this.getCommitPolicy(sfHolder);
        return commitPolicy.getDelay();
    }

    private CommitPolicy getCommitPolicy(SearchFactoryHolder sfHolder) {
        AbstractWorkspaceImpl workspace = sfHolder.extractWorkspace(A.class);
        return workspace.getCommitPolicy();
    }
}

