/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.indexedembedded;

import java.util.List;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1312")
public class IndexedEmbeddedWithAbstractClassTest {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    public void testAbstractClassAnnotatedWithIndexedLogsWarning() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(A.class).addClass(AbstractA.class).addClass(D.class);
        this.logged.expectMessage("HSEARCH000044", "@Indexed", AbstractA.class.getName());
        SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
        searchIntegrator.close();
    }

    @Test
    public void testInvalidConfiguredPathThrowsException() {
        try {
            SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(B.class).addClass(AbstractB.class).addClass(D.class);
            this.logged.expectMessageMissing("HSEARCH000044", "@Indexed", AbstractB.class.getName());
            new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
            Assert.fail((String)"Invalid configuration should throw an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Invalid exception code", (boolean)e.getMessage().startsWith("HSEARCH000216"));
        }
    }

    @Test
    public void testInvalidConfiguredPathThrowsExceptionAndIndexedAbstractClassLogsWarning() {
        try {
            SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(C.class).addClass(AbstractC.class).addClass(D.class);
            this.logged.expectMessage("HSEARCH000044", "@Indexed", AbstractC.class.getName());
            new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
            Assert.fail((String)"Invalid configuration should throw an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Invalid exception code", (boolean)e.getMessage().startsWith("HSEARCH000216"));
        }
    }

    @Indexed
    public static class D {
        @DocumentId
        long id;
        @Field
        String foo;
    }

    @Indexed
    public static final class C
    extends AbstractC {
    }

    @Indexed
    public static abstract class AbstractC {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"snafu", "fubar"})
        List<D> list;
    }

    @Indexed
    public static final class B
    extends AbstractB {
    }

    public static abstract class AbstractB {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"snafu", "fubar"})
        List<D> list;
    }

    @Indexed
    public static final class A
    extends AbstractA {
    }

    @Indexed
    public static abstract class AbstractA {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"foo"})
        List<D> list;
    }
}

