/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.sort.SortDistanceFieldAndReferenceContext;
import org.hibernate.search.query.dsl.sort.SortFieldContext;
import org.hibernate.search.query.dsl.sort.SortScoreContext;
import org.hibernate.search.query.dsl.sort.SortTermination;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1872")
public class SortDSLTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(IndexedEntry.class);

    @Before
    public void prepareTestData() {
        IndexedEntry entry0 = new IndexedEntry(0).setTextField("infrequent1 infrequent2 infrequent1 inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(1).setUniqueIntegerField(3).setUniqueDoubleField(2.0).setLocation(24.0, 31.9);
        IndexedEntry entry1 = new IndexedEntry(1).setTextField("inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(2).setUniqueIntegerField(1).setUniqueDoubleField(1.0).setLocation(23.9, 32.0).setPrevious(entry0);
        IndexedEntry entry2 = new IndexedEntry(2).setNonUniqueIntgerField(1).setPrevious(entry1);
        IndexedEntry entry3 = new IndexedEntry(3).setTextField("infrequent1 inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(1).setUniqueIntegerField(4).setUniqueDoubleField(3.0).setLocation(23.9, 32.1).setPrevious(entry2);
        entry0.setPrevious(entry3);
        this.storeData(entry0);
        this.storeData(entry1);
        this.storeData(entry2);
        this.storeData(entry3);
    }

    private QueryBuilder builder() {
        return this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(IndexedEntry.class).get();
    }

    @Test
    public void score() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"infrequent1").createQuery();
        Sort sort = this.builder().sort().byScore().createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 3));
        sort = ((SortScoreContext)this.builder().sort().byScore().asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0));
        sort = ((SortScoreContext)this.builder().sort().byScore().desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 3));
    }

    @Test
    public void docID() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byIndexOrder().createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 2, 3));
        sort = ((SortTermination)this.builder().sort().byIndexOrder().asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 2, 3));
        sort = ((SortTermination)this.builder().sort().byIndexOrder().desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 2, 1, 0));
    }

    @Test
    public void singleField() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test
    public void singleField_double_missingValue_use() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 2, 1));
    }

    @Test
    public void singleField_integer_missingValue_use() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").onMissingValue().use((Object)1)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").asc()).onMissingValue().use((Object)2)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").desc()).onMissingValue().use((Object)2)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 2, 1));
    }

    @Test
    public void singleField_stringFieldBridge() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("fieldBridgedStringField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test(expected=SearchException.class)
    public void singleField_stringFieldBridge_missingValue_use() throws Exception {
        ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").onMissingValue().use((Object)"1.5")).createSort();
    }

    @Test
    public void singleField_numericFieldBridge() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test
    public void singleField_numericFieldBridge_missingValue_use() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).asc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).desc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 2, 1));
    }

    @Test(expected=ClassCastException.class)
    public void singleField_numericFieldBridge_missingValue_use_nonRaw() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField", SortField.Type.DOUBLE).onMissingValue().use((Object)new WrappedDoubleValue(1.5))).createSort();
        this.query(query, sort);
    }

    @Test
    public void singleField_double_missingValue_sortFirst() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 3, 0, 1));
    }

    @Test
    public void singleField_integer_missingValue_sortFirst() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").asc()).onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").desc()).onMissingValue().sortFirst()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 3, 0, 1));
    }

    @Test
    public void singleField_missingValue_sortLast() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().sortLast()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 0, 3, 2));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().sortLast()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 0, 3, 2));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().sortLast()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test
    public void multipleFields() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 0, 3, 1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 0, 3, 1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 2, 1));
    }

    @Test
    public void distance() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 3, 2));
        sort = ((SortDistanceFieldAndReferenceContext)this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 3, 2));
        sort = ((SortDistanceFieldAndReferenceContext)this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 3, 1, 0));
    }

    @Test
    public void nativeLucene() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE, false)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE, true)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test
    public void fieldThenScore() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"inMultipleDocsWithUniqueScores").createQuery();
        Sort sort = this.builder().sort().byField("nonUniqueIntegerField").andByScore().createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").asc()).andByScore().createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").desc()).andByScore().createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 3, 0));
    }

    @Test
    public void scoreThenField() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"inMultipleDocsWithVariousScores").createQuery();
        Sort sort = this.builder().sort().byScore().andByField("uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 3));
        sort = ((SortScoreContext)this.builder().sort().byScore().asc()).andByField("uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 3, 0));
        sort = ((SortScoreContext)this.builder().sort().byScore().desc()).andByField("uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 3));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2587")
    public void embeddedField() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("previous.uniqueDoubleField").createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 2, 1, 0));
        sort = ((SortFieldContext)this.builder().sort().byField("previous.uniqueDoubleField").asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 2, 1, 0));
        sort = ((SortFieldContext)this.builder().sort().byField("previous.uniqueDoubleField").desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(0, 1, 2, 3));
    }

    private Matcher<List<EntityInfo>> returnsIDsInOrder(Integer ... idsInOrder) {
        final List<Integer> idsInOrderList = Arrays.asList(idsInOrder);
        return new TypeSafeMatcher<List<EntityInfo>>(){

            public void describeTo(Description description) {
                description.appendText("a list containing exactly (and in the same order) ").appendValue((Object)idsInOrderList);
            }

            protected void describeMismatchSafely(List<EntityInfo> item, Description mismatchDescription) {
                mismatchDescription.appendText("was ").appendValue(this.toIds(item));
            }

            private List<Object> toIds(List<EntityInfo> entityInfos) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (EntityInfo entityInfo : entityInfos) {
                    result.add(entityInfo.getProjection()[0]);
                }
                return result;
            }

            protected boolean matchesSafely(List<EntityInfo> actual) {
                return idsInOrderList.equals(this.toIds(actual));
            }
        };
    }

    private List<EntityInfo> query(Query luceneQuery, Sort sort) {
        ExtendedSearchIntegrator sf = this.sfHolder.getSearchFactory();
        HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{IndexedEntry.class});
        return hsQuery.projection(new String[]{"id"}).sort(sort).queryEntityInfos();
    }

    private void storeData(IndexedEntry entry) {
        Work work = new Work((Object)entry, (Serializable)Integer.valueOf(entry.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed
    @Spatial(name="location_hash", spatialMode=SpatialMode.HASH)
    public static class IndexedEntry
    implements Coordinates {
        @DocumentId
        @Field(name="idSort")
        @SortableField(forField="idSort")
        int id;
        @Field
        String textField;
        @Field
        @SortableField
        Integer nonUniqueIntegerField;
        @Field
        @SortableField
        Double uniqueDoubleField;
        @Field
        @SortableField
        Integer uniqueIntegerField;
        @Field(bridge=@FieldBridge(impl=WrappedStringValueFieldBridge.class))
        WrappedStringValue fieldBridgedStringField;
        @Field(bridge=@FieldBridge(impl=WrappedDoubleValueFieldBridge.class))
        WrappedDoubleValue fieldBridgedNumericField;
        @IndexedEmbedded(depth=1)
        IndexedEntry previous;
        Double latitude;
        Double longitude;

        public IndexedEntry() {
        }

        public IndexedEntry(int id) {
            this.id = id;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public IndexedEntry setTextField(String textField) {
            this.textField = textField;
            return this;
        }

        public IndexedEntry setNonUniqueIntgerField(Integer nonUniqueIntegerField) {
            this.nonUniqueIntegerField = nonUniqueIntegerField;
            return this;
        }

        public IndexedEntry setUniqueIntegerField(Integer uniqueIntegerField) {
            this.uniqueIntegerField = uniqueIntegerField;
            return this;
        }

        public IndexedEntry setUniqueDoubleField(Double uniqueDoubleField) {
            this.uniqueDoubleField = uniqueDoubleField;
            this.fieldBridgedStringField = new WrappedStringValue(uniqueDoubleField == null ? null : String.valueOf(uniqueDoubleField));
            this.fieldBridgedNumericField = new WrappedDoubleValue(uniqueDoubleField);
            return this;
        }

        public IndexedEntry setLocation(Double latitude, Double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
            return this;
        }

        public IndexedEntry setPrevious(IndexedEntry previous) {
            this.previous = previous;
            return this;
        }
    }

    public static class WrappedStringValueFieldBridge
    implements org.hibernate.search.bridge.FieldBridge,
    StringBridge {
        public String objectToString(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            String stringValue = ((WrappedStringValue)value).value;
            if (stringValue == null) {
                return;
            }
            luceneOptions.addFieldToDocument(name, stringValue, document);
        }
    }

    public static class WrappedStringValue {
        final String value;

        public WrappedStringValue(String value) {
            this.value = value;
        }
    }

    public static class WrappedDoubleValueFieldBridge
    implements MetadataProvidingFieldBridge,
    StringBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.DOUBLE).sortable(true);
        }

        public String objectToString(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            Double doubleValue = ((WrappedDoubleValue)value).value;
            if (doubleValue == null) {
                return;
            }
            luceneOptions.addNumericFieldToDocument(name, (Object)doubleValue, document);
            document.add((IndexableField)new DoubleDocValuesField(name, doubleValue.doubleValue()));
        }
    }

    public static class WrappedDoubleValue {
        final Double value;

        public WrappedDoubleValue(Double value) {
            this.value = value;
        }
    }
}

