/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.projection;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1786")
public class ProjectionConversionTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(ExampleEntity.class);

    @Before
    public void storeTestData() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        ExampleEntity entity = new ExampleEntity();
        entity.id = 1L;
        entity.someInteger = 5;
        entity.longEncodedAsText = 20L;
        entity.customBridgedKeyword = "lowercase-keyword";
        ExampleEntity embedded = new ExampleEntity();
        embedded.id = 2L;
        embedded.someInteger = 6;
        embedded.longEncodedAsText = 21L;
        embedded.customBridgedKeyword = "another-lowercase-keyword";
        ConflictingMappedType second = new ConflictingMappedType();
        second.id = "a string";
        second.customBridgedKeyword = 17L;
        entity.embedded = embedded;
        entity.second = second;
        Work work = new Work((Object)entity, (Serializable)entity.id, WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Test
    public void projectingExplicitId() {
        this.projectionTestHelper("__HSearch_id", 1L);
    }

    @Test
    public void projectingIdByPropertyName() {
        this.projectionTestHelper("id", 1L);
    }

    @Test
    public void projectingIdOnOverloadedMapping() {
        this.projectionTestHelper("stringTypedId", 1L);
    }

    @Test
    public void projectingIntegerField() {
        this.projectionTestHelper("someInteger", 5);
    }

    @Test
    public void projectingUnknownField() {
        this.projectionTestHelper("someNonExistingField", null);
    }

    @Test
    public void projectionWithCustomBridge() {
        this.projectionTestHelper("customBridgedKeyword", "lowercase-keyword");
    }

    @Test
    public void projectingEmbeddedIdByPropertyName() {
        this.projectionTestHelper("embedded.id", 2L);
    }

    @Test
    public void projectingEmbeddedIdOnOverloadedMapping() {
        this.projectionTestHelper("embedded.stringTypedId", 2L);
    }

    @Test
    public void projectingEmbeddedWithCustomBridge() {
        this.projectionTestHelper("embedded.customBridgedKeyword", "another-lowercase-keyword");
    }

    @Test
    public void projectingNotIncludedEmbeddedField() {
        this.projectionTestHelper("embedded.someInteger", null);
    }

    @Test
    public void projectingOnConflictingMappingEmbeddedField() {
        this.projectionTestHelper("second.customBridgedKeyword", 17L);
    }

    @Test
    public void projectingOnConflictingMappedIdField() {
        this.projectionTestHelper("second.id", "a string");
    }

    @Test
    public void concurrentMixedProjections() throws Exception {
        new ConcurrentRunner(1000, 20, new ConcurrentRunner.TaskFactory(){

            @Override
            public Runnable createRunnable(int i) throws Exception {
                return new Runnable(){

                    @Override
                    public void run() {
                        ProjectionConversionTest.this.projectingExplicitId();
                        ProjectionConversionTest.this.projectingIdOnOverloadedMapping();
                        ProjectionConversionTest.this.projectingIntegerField();
                        ProjectionConversionTest.this.projectingUnknownField();
                        ProjectionConversionTest.this.projectionWithCustomBridge();
                        ProjectionConversionTest.this.projectingEmbeddedIdByPropertyName();
                        ProjectionConversionTest.this.projectingEmbeddedIdOnOverloadedMapping();
                        ProjectionConversionTest.this.projectingEmbeddedWithCustomBridge();
                        ProjectionConversionTest.this.projectingOnConflictingMappingEmbeddedField();
                        ProjectionConversionTest.this.projectingOnConflictingMappedIdField();
                    }
                };
            }
        }).execute();
    }

    void projectionTestHelper(String projectionField, Object expectedValue) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(ExampleEntity.class).get();
        Query queryAllGuests = queryBuilder.all().createQuery();
        List queryEntityInfos = searchFactory.createHSQuery(queryAllGuests, new Class[]{ExampleEntity.class}).projection(new String[]{projectionField}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(0);
        Object projectedValue = entityInfo.getProjection()[0];
        Assert.assertEquals((Object)expectedValue, (Object)projectedValue);
    }

    public static class CustomTwoWayBridge
    implements TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, String.valueOf(value).toUpperCase(Locale.ENGLISH), document);
        }

        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            String stringValue = field.stringValue();
            return stringValue.toLowerCase(Locale.ENGLISH);
        }

        public String objectToString(Object object) {
            return String.valueOf(object);
        }
    }

    @Indexed
    public static class ConflictingMappedType {
        @DocumentId
        String id;
        @Field(store=Store.YES)
        Long customBridgedKeyword;
    }

    @Indexed
    public static class ExampleEntity {
        @DocumentId
        @Field(name="stringTypedId", store=Store.YES)
        Long id;
        @Field(store=Store.YES)
        Integer someInteger;
        @Field(store=Store.YES)
        @FieldBridge(impl=LongBridge.class)
        Long longEncodedAsText;
        @Field(store=Store.YES)
        @FieldBridge(impl=CustomTwoWayBridge.class)
        String customBridgedKeyword;
        @IndexedEmbedded(includePaths={"id", "stringTypedId", "customBridgedKeyword"}, includeEmbeddedObjectId=true)
        ExampleEntity embedded;
        @IndexedEmbedded(includeEmbeddedObjectId=true)
        ConflictingMappedType second;
    }
}

