/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.sort.SortFieldContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-2588")
@Category(value={SkipOnElasticsearch.class})
public class LuceneSortDSLTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(IndexedEntry.class);

    @Before
    public void prepareTestData() {
        IndexedEntry entry0 = new IndexedEntry(0).setUniqueDoubleField(2.0);
        IndexedEntry entry1 = new IndexedEntry(1).setUniqueDoubleField(1.0);
        IndexedEntry entry2 = new IndexedEntry(2);
        IndexedEntry entry3 = new IndexedEntry(3).setUniqueDoubleField(3.0);
        this.storeData(entry0);
        this.storeData(entry1);
        this.storeData(entry2);
        this.storeData(entry3);
    }

    private QueryBuilder builder() {
        return this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(IndexedEntry.class).get();
    }

    @Test
    public void singleField_numericFieldBridge_nonMetadataProviding() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).asc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(2, 1, 0, 3));
        sort = ((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).desc()).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 1, 2));
    }

    @Test
    public void singleField_numericFieldBridge_nonMetadataProviding_missingValue_use() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).asc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(1, 2, 0, 3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).desc()).onMissingValue().use((Object)1.5)).createSort();
        Assert.assertThat(this.query(query, sort), this.returnsIDsInOrder(3, 0, 2, 1));
    }

    @Test(expected=ClassCastException.class)
    public void singleField_numericFieldBridge_nonMetadataProviding_missingValue_use_nonRaw() throws Exception {
        Query query = this.builder().all().createQuery();
        Sort sort = ((SortFieldContext)this.builder().sort().byField("nonMetadataProvidingFieldBridgedNumericField", SortField.Type.DOUBLE).onMissingValue().use((Object)new WrappedDoubleValue(1.5))).createSort();
        this.query(query, sort);
    }

    private Matcher<List<EntityInfo>> returnsIDsInOrder(Integer ... idsInOrder) {
        final List<Integer> idsInOrderList = Arrays.asList(idsInOrder);
        return new TypeSafeMatcher<List<EntityInfo>>(){

            public void describeTo(Description description) {
                description.appendText("a list containing exactly (and in the same order) ").appendValue((Object)idsInOrderList);
            }

            protected void describeMismatchSafely(List<EntityInfo> item, Description mismatchDescription) {
                mismatchDescription.appendText("was ").appendValue(this.toIds(item));
            }

            private List<Object> toIds(List<EntityInfo> entityInfos) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (EntityInfo entityInfo : entityInfos) {
                    result.add(entityInfo.getProjection()[0]);
                }
                return result;
            }

            protected boolean matchesSafely(List<EntityInfo> actual) {
                return idsInOrderList.equals(this.toIds(actual));
            }
        };
    }

    private List<EntityInfo> query(Query luceneQuery, Sort sort) {
        ExtendedSearchIntegrator sf = this.sfHolder.getSearchFactory();
        HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{IndexedEntry.class});
        return hsQuery.projection(new String[]{"id"}).sort(sort).queryEntityInfos();
    }

    private void storeData(IndexedEntry entry) {
        Work work = new Work((Object)entry, (Serializable)Integer.valueOf(entry.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed
    public static class IndexedEntry {
        @DocumentId
        int id;
        @Field(name="nonMetadataProvidingFieldBridgedNumericField", bridge=@FieldBridge(impl=WrappedDoubleValueNonMetadataProvidingFieldBridge.class))
        @NumericField(forField="nonMetadataProvidingFieldBridgedNumericField")
        WrappedDoubleValue fieldBridgedNumericField;

        public IndexedEntry() {
        }

        public IndexedEntry(int id) {
            this.id = id;
        }

        public IndexedEntry setUniqueDoubleField(Double uniqueDoubleField) {
            this.fieldBridgedNumericField = new WrappedDoubleValue(uniqueDoubleField);
            return this;
        }
    }

    public static class WrappedDoubleValueNonMetadataProvidingFieldBridge
    implements org.hibernate.search.bridge.FieldBridge,
    StringBridge {
        public String objectToString(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            Double doubleValue = ((WrappedDoubleValue)value).value;
            if (doubleValue == null) {
                return;
            }
            luceneOptions.addNumericFieldToDocument(name, (Object)doubleValue, document);
            luceneOptions.addNumericDocValuesFieldToDocument(name, (Number)doubleValue, document);
        }
    }

    public static class WrappedDoubleValue {
        final Double value;

        public WrappedDoubleValue(Double value) {
            this.value = value;
        }
    }
}

