/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.io.IOException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.SearchException;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.JGroupsHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.PropertiesHelper;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;

public class CacheManagerServiceProvider
implements ServiceProvider<EmbeddedCacheManager> {
    private static final Logger log = LoggerFactory.make();
    public static final String DEFAULT_INFINISPAN_CONFIGURATION_RESOURCENAME = "default-hibernatesearch-infinispan.xml";
    public static final String CACHE_MANAGER_RESOURCE_PROP = "hibernate.search.infinispan.cachemanager_jndiname";
    public static final String INFINISPAN_CONFIGURATION_RESOURCENAME = "hibernate.search.infinispan.configuration_resourcename";
    private EmbeddedCacheManager cacheManager;
    private boolean manageCacheManager = false;

    public void start(Properties properties) {
        JGroupsHelper.verifyIPv4IsPreferred();
        String name = PropertiesHelper.getString((String)CACHE_MANAGER_RESOURCE_PROP, (Properties)properties, null);
        if (name == null) {
            String cfgName = properties.getProperty(INFINISPAN_CONFIGURATION_RESOURCENAME, DEFAULT_INFINISPAN_CONFIGURATION_RESOURCENAME);
            try {
                this.cacheManager = new DefaultCacheManager(cfgName);
                this.cacheManager.start();
                this.manageCacheManager = true;
            }
            catch (IOException e) {
                throw new SearchException("Could not start Infinispan CacheManager using as configuration file: " + cfgName, (Throwable)e);
            }
        } else {
            this.cacheManager = this.locateCacheManager(name, NamingHelper.getJndiProperties((Properties)properties));
            this.manageCacheManager = false;
        }
    }

    private EmbeddedCacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)ctx.lookup(jndiNamespace);
            return embeddedCacheManager;
        }
        catch (NamingException ne) {
            String msg = "Unable to retrieve CacheManager from JNDI [" + jndiNamespace + "]";
            log.error(msg, (Throwable)ne);
            throw new SearchException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.error("Unable to release initial context", (Throwable)ne);
                }
            }
        }
    }

    public EmbeddedCacheManager getService() {
        return this.cacheManager;
    }

    public void stop() {
        if (this.cacheManager != null && this.manageCacheManager) {
            this.cacheManager.stop();
        }
    }
}

