/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import junit.framework.Assert;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider;
import org.hibernate.search.test.util.SearchFactoryHolder;
import org.hibernate.search.test.util.TestForIssue;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1734")
public class InfinispanLockFactoryOptionsTest {
    @Rule
    public SearchFactoryHolder holder = new SearchFactoryHolder(new Class[]{BookTypeZero.class, BookTypeOne.class, BookTypeTwo.class, BookTypeThree.class, BookTypeFour.class}).withProperty("hibernate.search.default.directory_provider", (Object)"infinispan").withProperty("hibernate.search.infinispan.configuration_resourcename", (Object)"notclustered-infinispan.xml").withProperty("hibernate.search.INDEX1.locking_strategy", (Object)"none").withProperty("hibernate.search.INDEX2.locking_strategy", (Object)CustomLockFactoryProvider.class.getName()).withProperty("hibernate.search.INDEX3.locking_strategy", (Object)"single");

    @Test
    public void verifyDefaulInfinispanLock() {
        this.verifyLockFactoryForIndexIs("INDEX0", BaseLockFactory.class);
    }

    @Test
    public void verifyNoLocking() {
        this.verifyLockFactoryForIndexIs("INDEX1", NoLockFactory.class);
    }

    @Test
    public void verifyCustomLocking() {
        this.verifyLockFactoryForIndexIs("INDEX2", SingleInstanceLockFactory.class);
    }

    @Test
    public void verifyExplicitSingle() {
        this.verifyLockFactoryForIndexIs("INDEX3", SingleInstanceLockFactory.class);
    }

    @Test
    public void verifyDefaultIsInherited() {
        this.verifyLockFactoryForIndexIs("INDEX4", BaseLockFactory.class);
    }

    private void verifyLockFactoryForIndexIs(String indexName, Class<? extends LockFactory> expectedType) {
        Directory directory = this.directoryByName(indexName);
        LockFactory lockFactory = directory.getLockFactory();
        Assert.assertEquals(expectedType, lockFactory.getClass());
    }

    private Directory directoryByName(String indexName) {
        IndexManager indexManager = this.holder.getSearchFactory().getIndexManagerHolder().getIndexManager(indexName);
        Assert.assertNotNull((Object)indexManager);
        DirectoryBasedIndexManager dpIm = (DirectoryBasedIndexManager)indexManager;
        DirectoryProvider directoryProvider = dpIm.getDirectoryProvider();
        Assert.assertNotNull((Object)directoryProvider);
        Assert.assertTrue((String)"Isn't an Infinispan Directory!", (boolean)(directoryProvider instanceof InfinispanDirectoryProvider));
        return dpIm.getDirectoryProvider().getDirectory();
    }

    @Indexed(index="INDEX4")
    public static class BookTypeFour
    extends BookTypeZero {
    }

    @Indexed(index="INDEX3")
    public static class BookTypeThree
    extends BookTypeZero {
    }

    @Indexed(index="INDEX2")
    public static class BookTypeTwo
    extends BookTypeZero {
    }

    @Indexed(index="INDEX1")
    public static class BookTypeOne
    extends BookTypeZero {
    }

    @Indexed(index="INDEX0")
    public static class BookTypeZero {
        @DocumentId
        int id;
        @Field
        String title;
    }
}

