/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.io.IOException;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-1575")
public class OverrideConfigurationAppliedTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testOverrideOptionGetsApplied() throws IOException {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.default.directory_provider", "infinispan").addProperty("hibernate.search.infinispan.configuration.transport_override_resourcename", "not existing").addClass(Dvd.class);
        this.exceptions.expect(SearchException.class);
        this.exceptions.expectMessage("HSEARCH000103");
        new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

