/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.integration.osgi;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.SearchFactory;
import org.hibernate.search.engine.Version;
import org.hibernate.search.test.integration.osgi.Muppet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class HibernateSearchWithKarafIT {
    private String currentVersion = Version.getVersionString();
    @Inject
    private BundleContext bundleContext;
    private ServiceReference serviceReference;

    @Configuration
    public Option[] config() {
        MavenArtifactUrlReference karafUrl = CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").version("3.0.0").type("tar.gz");
        MavenUrlReference karafStandardRepo = CoreOptions.maven().groupId("org.apache.karaf.features").artifactId("standard").classifier("features").type("xml").versionAsInProject();
        File examDir = new File("target/exam");
        File ariesLogDir = new File(examDir, "/aries/log");
        return new Option[]{KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)karafUrl).unpackDirectory(examDir).useDeployFolder(false), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.features((UrlReference)karafStandardRepo, (String[])new String[]{"scr"}), KarafDistributionOption.features((String)("mvn:org.hibernate/hibernate-search-integrationtest-osgi-features/" + this.currentVersion + "/xml/features"), (String[])new String[]{"hibernate-search"}), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.aries.transaction.cfg", (String)"aries.transaction.howl.logFileDir", (String)ariesLogDir.getAbsolutePath()), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.aries.transaction.cfg", (String)"aries.transaction.recoverable", (String)"true"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.aries.transaction.cfg", (String)"aries.transaction.timeout", (String)"600"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)"log4j.rootLogger", (String)"INFO, out")};
    }

    @Before
    public void setUp() {
        this.serviceReference = this.bundleContext.getServiceReference(SessionFactory.class.getName());
        Assert.assertNotNull((String)"The service reference should not be null", (Object)this.serviceReference);
    }

    @After
    public void tearDown() {
        this.bundleContext.ungetService(this.serviceReference);
    }

    @Test
    public void testAccessSessionFactory() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)this.bundleContext.getService(this.serviceReference);
        Assert.assertNotNull((String)"The session factory should not be null", (Object)sessionFactory);
    }

    @Test
    public void testAccessSearchFactory() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)this.bundleContext.getService(this.serviceReference);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessionFactory.openSession());
        Assert.assertNotNull((String)"Unable to create fulltext session from ORM Session", (Object)fullTextSession);
        SearchFactory searchFactory = fullTextSession.getSearchFactory();
        Assert.assertNotNull((String)"Unable to access SearchFactory", (Object)searchFactory);
        Assert.assertEquals((String)"There should only be one indexed type", (long)1L, (long)searchFactory.getIndexedTypes().size());
        Assert.assertEquals((String)"Wrong indexed type", Muppet.class, searchFactory.getIndexedTypes().iterator().next());
    }

    @Test
    public void testIndexAndSearch() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)this.bundleContext.getService(this.serviceReference);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessionFactory.openSession());
        this.assertElmoIndexed(fullTextSession, false);
        this.persistElmo(fullTextSession);
        this.assertElmoIndexed(fullTextSession, true);
    }

    @Test
    public void testBatchIndexing() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)this.bundleContext.getService(this.serviceReference);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessionFactory.openSession());
        AssertingMassIndexerProgressMonitor progressMonitor = new AssertingMassIndexerProgressMonitor(0);
        fullTextSession.createIndexer(new Class[]{Muppet.class}).progressMonitor((MassIndexerProgressMonitor)progressMonitor).startAndWait();
        progressMonitor.assertExpectedProgressMade();
        this.persistElmo(fullTextSession);
        progressMonitor = new AssertingMassIndexerProgressMonitor(1);
        fullTextSession.createIndexer(new Class[]{Muppet.class}).progressMonitor((MassIndexerProgressMonitor)progressMonitor).startAndWait();
        progressMonitor.assertExpectedProgressMade();
    }

    private void persistElmo(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        Muppet elmo = new Muppet("Elmo");
        fullTextSession.persist((Object)elmo);
        transaction.commit();
        fullTextSession.clear();
    }

    private void assertElmoIndexed(FullTextSession fullTextSession, boolean indexed) {
        MatchAllDocsQuery matchAllQuery = new MatchAllDocsQuery();
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)matchAllQuery, new Class[]{Muppet.class});
        if (indexed) {
            Assert.assertEquals((String)"Elmo should be there", (long)1L, (long)query.list().size());
            Muppet muppet = (Muppet)query.list().get(0);
            Assert.assertEquals((String)"Index muppet is not Elmo", (Object)"Elmo", (Object)muppet.getName());
        } else {
            Assert.assertEquals((String)"Elmo should not be there", (long)0L, (long)query.list().size());
        }
    }

    public class AssertingMassIndexerProgressMonitor
    implements MassIndexerProgressMonitor {
        private final AtomicLong totalCount = new AtomicLong();
        private final AtomicLong finishedCount = new AtomicLong();
        private final int expectedTotalCount;

        public AssertingMassIndexerProgressMonitor(int expectedTotalCount) {
            this.expectedTotalCount = expectedTotalCount;
        }

        public void documentsAdded(long increment) {
        }

        public void documentsBuilt(int number) {
        }

        public void entitiesLoaded(int size) {
        }

        public void addToTotalCount(long count) {
            this.totalCount.addAndGet(count);
        }

        public void indexingCompleted() {
            this.finishedCount.incrementAndGet();
        }

        public void assertExpectedProgressMade() {
            Assert.assertEquals((String)"Unexpected total count", (long)this.expectedTotalCount, (long)this.totalCount.get());
            Assert.assertEquals((String)"Finished called more than once", (long)1L, (long)this.finishedCount.get());
        }
    }
}

