/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, ValueRef<K, V>> map;
    private ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.map = this.createMap(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        this.map = this.createMap(initialCapacity);
    }

    public WeakValueHashMap() {
        this.map = this.createMap();
    }

    public WeakValueHashMap(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    private ValueRef<K, V> create(K key, V value, ReferenceQueue<V> q) {
        return WeakValueRef.create(key, value, q);
    }

    private Map<K, ValueRef<K, V>> createMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    private Map<K, ValueRef<K, V>> createMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    protected Map<K, ValueRef<K, V>> createMap() {
        return new HashMap();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        ValueRef<K, V> ref = this.map.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        ValueRef<K, V> ref = this.create(key, value, this.queue);
        ValueRef<K, V> result = this.map.put(key, ref);
        if (result != null) {
            return result.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueRef<K, V> result = this.map.remove(key);
        if (result != null) {
            return result.get();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        return new EntrySet();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    private void processQueue() {
        ValueRef ref = (ValueRef)((Object)this.queue.poll());
        while (ref != null) {
            if (ref == this.map.get(ref.getKey())) {
                this.map.remove(ref.getKey());
            }
            ref = (ValueRef)((Object)this.queue.poll());
        }
    }

    public static interface ValueRef<K, V>
    extends Map.Entry<K, V> {
        public V get();
    }

    private static class WeakValueRef<K, V>
    extends WeakReference<V>
    implements ValueRef<K, V> {
        public K key;

        static <K, V> WeakValueRef<K, V> create(K key, V val, ReferenceQueue<V> q) {
            if (val == null) {
                return null;
            }
            return new WeakValueRef<K, V>(key, val, q);
        }

        private WeakValueRef(K key, V val, ReferenceQueue<V> q) {
            super(val, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue");
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, ValueRef<K, V>>> delegate;

        public EntrySetIterator(Iterator<Map.Entry<K, ValueRef<K, V>>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry next = this.delegate.next();
            return next.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(WeakValueHashMap.this.map.entrySet().iterator());
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }
    }
}

