/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import org.apache.lucene.store.Lock;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class BaseLuceneLock
extends Lock {
    private static final Log log = LogFactory.getLog(BaseLuceneLock.class);
    private final Cache<Object, Object> noCacheStoreCache;
    private final String lockName;
    private final String indexName;
    private final FileCacheKey keyOfLock;

    BaseLuceneLock(Cache<?, ?> cache, String indexName, String lockName) {
        this.noCacheStoreCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.SKIP_INDEXING});
        this.lockName = lockName;
        this.indexName = indexName;
        this.keyOfLock = new FileCacheKey(indexName, lockName);
    }

    public boolean obtain() {
        Object previousValue = this.noCacheStoreCache.putIfAbsent((Object)this.keyOfLock, (Object)this.keyOfLock);
        if (previousValue == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock: %s acquired for index: %s", (Object)this.lockName, (Object)this.indexName);
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Lock: %s not aquired for index: %s, was taken already.", (Object)this.lockName, (Object)this.indexName);
        }
        return false;
    }

    public void release() {
        this.clearLock();
    }

    public void clearLock() {
        Object previousValue = this.noCacheStoreCache.remove((Object)this.keyOfLock);
        if (previousValue != null && log.isTraceEnabled()) {
            log.tracef("Lock removed for index: %s", (Object)this.indexName);
        }
    }

    public boolean isLocked() {
        boolean locked = this.noCacheStoreCache.containsKey((Object)this.keyOfLock);
        return locked;
    }
}

