/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.regex;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQueryCapable;
import org.apache.lucene.search.regex.RegexTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class RegexQuery
extends MultiTermQuery
implements RegexQueryCapable {
    private RegexCapabilities regexImpl = new JavaUtilRegexCapabilities();
    private Term term;

    public RegexQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setRegexImplementation(RegexCapabilities impl) {
        this.regexImpl = impl;
    }

    public RegexCapabilities getRegexImplementation() {
        return this.regexImpl;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new RegexTermEnum(reader, this.term, this.regexImpl);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexQuery that = (RegexQuery)o;
        return this.regexImpl.equals(that.regexImpl);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.regexImpl.hashCode();
        return result;
    }
}

