/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.logging;

import java.io.IOException;
import org.infinispan.CacheException;
import org.infinispan.loaders.CacheLoaderException;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.util.logging.Log {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error in suspending transaction", id=15001)
    public void errorSuspendingTransaction(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to start transaction", id=15002)
    public void unableToStartTransaction(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to commit work done", id=15003)
    public void unableToCommitTransaction(@Cause Exception var1);

    @Message(value="Unexpected format of key in String form: '%s'", id=15004)
    public IllegalArgumentException keyMappperUnexpectedStringFormat(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Lucene CacheLoader is ignoring key '%s'", id=15005)
    public void cacheLoaderIgnoringKey(Object var1);

    @Message(value="The LuceneCacheLoader requires a directory; invalid path '%s'", id=15006)
    public CacheException rootDirectoryIsNotADirectory(String var1);

    @Message(value="LuceneCacheLoader was unable to create the root directory at path '%s'", id=15007)
    public CacheException unableToCreateDirectory(String var1);

    @Message(value="IOException happened in the CacheLoader", id=15008)
    public CacheLoaderException exceptionInCacheLoader(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to close FSDirectory", id=15009)
    public void errorOnFSDirectoryClose(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error happened while looking for FSDirectories in '%s'", id=15010)
    public void couldNotWalkDirectory(String var1, @Cause CacheLoaderException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The configured autoChunkSize is too small for segment file %s as it is %d bytes; auto-scaling chunk size to %d", id=15011)
    public void rescalingChunksize(String var1, long var2, int var4);

    @Message(value="Could not instantiate Directory implementation for Lucene 4 compatibility", id=15012)
    public CacheException failedToCreateLucene4Directory(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Lucene Directory detected Apache Lucene v. '%d' - this will affect which APIs are going to be provided", id=15013)
    public void detectedLuceneVersion(int var1);
}

