/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheImpl;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.ClassLoaderAwareListenable;
import org.infinispan.util.concurrent.NotifyingFuture;

public class DecoratedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final EnumSet<Flag> flags;
    private final WeakReference<ClassLoader> classLoader;
    private final CacheImpl<K, V> cacheImplementation;

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader) {
        this(delegate, classLoader, null);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, Flag ... flags) {
        this(delegate, (ClassLoader)null, flags);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader, Flag ... flags) {
        super(delegate);
        if (flags == null || flags.length == 0) {
            this.flags = null;
        } else {
            this.flags = EnumSet.noneOf(Flag.class);
            this.flags.addAll(Arrays.asList(flags));
        }
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        if (flags == null && classLoader == null) {
            throw new IllegalArgumentException("There is no point in using a DecoratedCache if neither a ClassLoader nor any Flags are set.");
        }
        this.cacheImplementation = (CacheImpl)delegate;
    }

    private DecoratedCache(CacheImpl<K, V> delegate, ClassLoader classLoader, EnumSet<Flag> newFlags) {
        super(delegate);
        this.flags = newFlags;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.cacheImplementation = delegate;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader passed in cannot be null!");
        }
        return new DecoratedCache<K, V>(this.cacheImplementation, classLoader, this.flags);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        List<Flag> flagsToAdd = Arrays.asList(flags);
        if (this.flags != null && this.flags.containsAll(flagsToAdd)) {
            return this;
        }
        if (this.flags == null) {
            return new DecoratedCache<K, V>(this.cacheImplementation, (ClassLoader)this.classLoader.get(), EnumSet.copyOf(flagsToAdd));
        }
        EnumSet<Flag> newFlags = EnumSet.copyOf(this.flags);
        newFlags.addAll(flagsToAdd);
        return new DecoratedCache<K, V>(this.cacheImplementation, (ClassLoader)this.classLoader.get(), newFlags);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.cacheImplementation.getClassLoader();
        }
        return (ClassLoader)this.classLoader.get();
    }

    @Override
    public void stop() {
        this.cacheImplementation.stop((ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean lock(K ... keys) {
        return this.cacheImplementation.lock((Collection<K>)Arrays.asList(keys), this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cacheImplementation.lock(keys, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cacheImplementation.putForExternalRead(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void evict(K key) {
        this.cacheImplementation.evict(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.cacheImplementation.putAll(map, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        this.cacheImplementation.putAll(map, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value) {
        return this.cacheImplementation.putAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cacheImplementation.putAllAsync(data, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Void> clearAsync() {
        return this.cacheImplementation.clearAsync(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> removeAsync(Object key) {
        return this.cacheImplementation.removeAsync(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cacheImplementation.removeAsync(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.cacheImplementation.replaceAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> getAsync(K key) {
        return this.cacheImplementation.getAsync(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public int size() {
        return this.cacheImplementation.size(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean isEmpty() {
        return this.cacheImplementation.isEmpty(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheImplementation.containsKey(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V get(Object key) {
        return this.cacheImplementation.get(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value) {
        return this.cacheImplementation.put(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V remove(Object key) {
        return this.cacheImplementation.remove(key, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cacheImplementation.putAll(m, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public void clear() {
        this.cacheImplementation.clear(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public Set<K> keySet() {
        return this.cacheImplementation.keySet(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public Collection<V> values() {
        return this.cacheImplementation.values(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cacheImplementation.entrySet(this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cacheImplementation.putIfAbsent(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cacheImplementation.remove(key, value, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replace(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value) {
        return this.cacheImplementation.replace(key, value, this.cacheImplementation.defaultMetadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void addListener(Object listener) {
        if (!(this.cacheImplementation.notifier instanceof ClassLoaderAwareListenable)) {
            throw new IllegalStateException("The CacheNotifier does not implement the ClassLoaderAwareListenable interface");
        }
        ((ClassLoaderAwareListenable)((Object)this.cacheImplementation.notifier)).addListener(listener, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cacheImplementation.put(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, value, metadata, this.flags, (ClassLoader)this.classLoader.get());
    }

    @Override
    public CacheEntry getCacheEntry(K key) {
        return this.cacheImplementation.getCacheEntry(key, this.flags, (ClassLoader)this.classLoader.get());
    }
}

