/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseRpcCommand
implements FlagAffectedCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextContainer icc;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private boolean acquireRemoteLock;
    private GlobalTransaction gtx;
    private Set<Flag> flags;
    private DistributionManager distributionManager;
    private TransactionTable txTable;
    private InternalEntryFactory entryFactory;
    private int topologyId;
    private Equivalence keyEquivalence;

    private ClusteredGetCommand() {
        super(null);
    }

    public ClusteredGetCommand(String cacheName) {
        super(cacheName);
    }

    public ClusteredGetCommand(Object key, String cacheName, Set<Flag> flags, boolean acquireRemoteLock, GlobalTransaction gtx, Equivalence keyEquivalence) {
        super(cacheName);
        this.key = key;
        this.flags = flags;
        this.acquireRemoteLock = acquireRemoteLock;
        this.gtx = gtx;
        this.keyEquivalence = keyEquivalence;
        if (acquireRemoteLock && gtx == null) {
            throw new IllegalArgumentException("Cannot have null tx if we need to acquire locks");
        }
    }

    public void initialize(InvocationContextContainer icc, CommandsFactory commandsFactory, InternalEntryFactory entryFactory, InterceptorChain interceptorChain, DistributionManager distributionManager, TransactionTable txTable, Equivalence keyEquivalence) {
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.txTable = txTable;
        this.entryFactory = entryFactory;
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public InternalCacheValue perform(InvocationContext context) throws Throwable {
        GetKeyValueCommand command;
        InvocationContext invocationContext;
        CacheEntry cacheEntry;
        this.acquireLocksIfNeeded();
        if (this.distributionManager != null && this.distributionManager.isAffectedByRehash(this.key)) {
            return null;
        }
        EnumSet<Flag> commandFlags = EnumSet.of(Flag.SKIP_REMOTE_LOOKUP, Flag.CACHE_MODE_LOCAL);
        if (this.flags != null) {
            commandFlags.addAll(this.flags);
        }
        if ((cacheEntry = (CacheEntry)this.invoker.invoke(invocationContext = this.icc.createRemoteInvocationContextForCommand(command = this.commandsFactory.buildGetKeyValueCommand(this.key, commandFlags, true), this.getOrigin()), command)) == null) {
            if (trace) {
                log.trace("Did not find anything, returning null");
            }
            return null;
        }
        if (cacheEntry instanceof MVCCEntry) {
            if (trace) {
                log.trace("Handling an internal cache entry...");
            }
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            return this.entryFactory.createValue(mvccEntry);
        }
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)cacheEntry;
        return internalCacheEntry.toInternalCacheValue();
    }

    private void acquireLocksIfNeeded() throws Throwable {
        if (this.acquireRemoteLock) {
            LockControlCommand lockControlCommand = this.commandsFactory.buildLockControlCommand(this.key, this.flags, this.gtx);
            lockControlCommand.init(this.invoker, this.icc, this.txTable);
            lockControlCommand.perform(null);
        }
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.flags, this.acquireRemoteLock, this.gtx};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        int i = 0;
        this.key = args[i++];
        this.flags = (Set)args[i++];
        this.acquireRemoteLock = (Boolean)args[i++];
        this.gtx = (GlobalTransaction)args[i];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        if (this.key != null) {
            if (this.keyEquivalence != null) {
                if (!this.keyEquivalence.equals(this.key, that.key)) return false;
                return true;
            }
        } else {
            if (that.key != null) return false;
            return true;
        }
        if (this.key.equals(that.key)) return true;
        return false;
    }

    public int hashCode() {
        int result = this.key != null ? (this.keyEquivalence != null ? this.keyEquivalence.hashCode(this.key) : this.key.hashCode()) : 0;
        return result;
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.flags + "}";
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
        this.flags = flags;
    }

    @Override
    public void setFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return;
        }
        if (this.flags == null) {
            this.flags = EnumSet.copyOf(Arrays.asList(flags));
        } else {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    @Override
    public boolean hasFlag(Flag flag) {
        return this.flags != null && this.flags.contains((Object)flag);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitUnknownCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(Metadata metadata) {
    }
}

