/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.List;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.batch.BatchContainer;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.AbstractInvocationContextContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;

public class TransactionalInvocationContextContainer
extends AbstractInvocationContextContainer {
    private TransactionManager tm;
    private TransactionTable transactionTable;
    private boolean isThreadLocalRequired;
    private BatchContainer batchContainer;
    private boolean batchingEnabled;

    @Inject
    public void init(TransactionManager tm, TransactionTable transactionTable, Configuration config, BatchContainer batchContainer) {
        super.init(config);
        this.tm = tm;
        this.transactionTable = transactionTable;
        this.batchContainer = batchContainer;
        this.batchingEnabled = config.invocationBatching().enabled();
    }

    @Override
    @Start
    public void start() {
        super.start();
        this.isThreadLocalRequired = this.config.clustering().cacheMode().isClustered() || this.config.storeAsBinary().enabled() || this.hasClusterCacheLoader();
    }

    private boolean hasClusterCacheLoader() {
        boolean hasCacheLoaders = this.config.loaders().usingCacheLoaders();
        if (hasCacheLoaders) {
            List<CacheLoaderConfiguration> loaderConfigs = this.config.loaders().cacheLoaders();
            for (CacheLoaderConfiguration loaderConfig : loaderConfigs) {
                if (!(loaderConfig instanceof ClusterCacheLoaderConfiguration)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        return this.newNonTxInvocationContext(true);
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        SingleKeyNonTxInvocationContext ctx = new SingleKeyNonTxInvocationContext(true, this.keyEq);
        if (this.isThreadLocalRequired) {
            this.ctxHolder.set(ctx);
        }
        return ctx;
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        Transaction runningTx = this.getRunningTx();
        if (runningTx == null && !isWrite) {
            if (keyCount == 1) {
                return this.createSingleKeyNonTxInvocationContext();
            }
            return this.newNonTxInvocationContext(true);
        }
        return this.createInvocationContext(runningTx);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Cannot create a transactional context without a valid Transaction instance.");
        }
        LocalTxInvocationContext localContext = new LocalTxInvocationContext(this.keyEq);
        LocalTransaction localTransaction = this.transactionTable.getLocalTransaction(tx);
        localContext.setLocalTransaction(localTransaction);
        localContext.setTransaction(tx);
        this.ctxHolder.set(localContext);
        return localContext;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext() {
        LocalTxInvocationContext ctx = new LocalTxInvocationContext(this.keyEq);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        RemoteTxInvocationContext ctx = new RemoteTxInvocationContext();
        ctx.setOrigin(origin);
        ctx.setRemoteTransaction(tx);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        NonTxInvocationContext nonTxInvocationContext = this.newNonTxInvocationContext(false);
        nonTxInvocationContext.setOrigin(origin);
        return nonTxInvocationContext;
    }

    private Transaction getRunningTx() {
        try {
            Transaction transaction = null;
            if (this.batchingEnabled) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            if (transaction == null) {
                transaction = this.tm.getTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }

    protected final NonTxInvocationContext newNonTxInvocationContext(boolean local) {
        NonTxInvocationContext ctx = new NonTxInvocationContext(this.keyEq);
        ctx.setOriginLocal(local);
        this.ctxHolder.set(ctx);
        return ctx;
    }
}

