/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.CollectionFactory;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;
import org.infinispan.util.concurrent.NoOpFuture;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ManagerImpl
implements L1Manager {
    private static final Log log = LogFactory.getLog(L1ManagerImpl.class);
    private final boolean trace = log.isTraceEnabled();
    private Configuration configuration;
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private int threshold;
    private long l1Lifespan;
    private ExecutorService asyncTransportExecutor;
    private final ConcurrentMap<Object, ConcurrentMap<Address, Long>> requestors = CollectionFactory.makeConcurrentMap();
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> scheduledRequestorsCleanupTask;
    private TimeService timeService;
    private RpcOptions syncRpcOptions;
    private RpcOptions syncIgnoreLeaversRpcOptions;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CommandsFactory commandsFactory, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, @ComponentName(value="org.infinispan.executors.eviction") ScheduledExecutorService scheduledExecutor, TimeService timeService) {
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.configuration = configuration;
        this.asyncTransportExecutor = asyncTransportExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.timeService = timeService;
    }

    @Start(priority=3)
    public void start() {
        this.threshold = this.configuration.clustering().l1().invalidationThreshold();
        this.l1Lifespan = this.configuration.clustering().l1().lifespan();
        if (this.configuration.clustering().l1().cleanupTaskFrequency() > 0L) {
            this.scheduledRequestorsCleanupTask = this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    L1ManagerImpl.this.cleanUpRequestors();
                }
            }, this.configuration.clustering().l1().cleanupTaskFrequency(), this.configuration.clustering().l1().cleanupTaskFrequency(), TimeUnit.MILLISECONDS);
        } else {
            log.warn("Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!");
        }
        this.syncRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS, false).build();
        this.syncIgnoreLeaversRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false).build();
    }

    @Stop(priority=3)
    public void stop() {
        if (this.scheduledRequestorsCleanupTask != null) {
            this.scheduledRequestorsCleanupTask.cancel(true);
        }
    }

    private void cleanUpRequestors() {
        long expiryTime = this.timeService.wallClockTime() - this.l1Lifespan;
        for (Map.Entry entry : this.requestors.entrySet()) {
            Object key = entry.getKey();
            ConcurrentMap reqs = (ConcurrentMap)entry.getValue();
            this.prune(reqs, expiryTime);
            if (!reqs.isEmpty()) continue;
            this.requestors.remove(key);
        }
    }

    private void prune(ConcurrentMap<Address, Long> reqs, long expiryTime) {
        for (Map.Entry req : reqs.entrySet()) {
            if ((Long)req.getValue() >= expiryTime) continue;
            reqs.remove(req.getKey());
        }
    }

    @Override
    public void addRequestor(Object key, Address origin) {
        ConcurrentMap<Address, Long> as = (ConcurrentMap<Address, Long>)this.requestors.get(key);
        log.tracef("Registering requestor %s for key '%s'", origin, key);
        long now = this.timeService.wallClockTime();
        if (as == null) {
            as = CollectionFactory.makeConcurrentMap();
            as.put(origin, now);
            ConcurrentMap<Address, Long> previousAs = this.requestors.putIfAbsent(key, as);
            if (previousAs != null) {
                previousAs.put(origin, now);
            }
        } else {
            as.put(origin, now);
        }
    }

    @Override
    public Future<Object> flushCacheWithSimpleFuture(Collection<Object> keys, Object retval, Address origin, boolean assumeOriginKeptEntryInL1) {
        return this.flushCache(keys, retval, origin, assumeOriginKeptEntryInL1, false);
    }

    @Override
    public Future<Object> flushCache(Collection<Object> keys, Address origin, boolean assumeOriginKeptEntryInL1) {
        final Collection<Address> invalidationAddresses = this.buildInvalidationAddressList(keys, origin, assumeOriginKeptEntryInL1);
        int nodes = invalidationAddresses.size();
        if (nodes > 0) {
            InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(origin, false, InfinispanCollections.<Flag>emptySet(), keys);
            final SingleRpcCommand rpcCommand = this.commandsFactory.buildSingleRpcCommand(ic);
            boolean multicast = this.isUseMulticast(nodes);
            if (this.trace) {
                log.tracef("Invalidating keys %s on nodes %s. Use multicast? %s", keys, invalidationAddresses, multicast);
            }
            Runnable toExecute = multicast ? new Runnable(){

                @Override
                public void run() {
                    L1ManagerImpl.this.rpcManager.invokeRemotely(null, (ReplicableCommand)rpcCommand, L1ManagerImpl.this.rpcManager.getDefaultRpcOptions(true));
                }
            } : new Runnable(){

                @Override
                public void run() {
                    L1ManagerImpl.this.rpcManager.invokeRemotely((Collection<Address>)invalidationAddresses, (ReplicableCommand)rpcCommand, L1ManagerImpl.this.syncRpcOptions);
                }
            };
            return this.asyncTransportExecutor.submit(toExecute);
        }
        if (this.trace) {
            log.tracef("No L1 caches to invalidate for keys %s", keys);
        }
        return null;
    }

    private Future<Object> flushCache(Collection<Object> keys, final Object retval, Address origin, boolean assumeOriginKeptEntryInL1, boolean useNotifyingFuture) {
        Collection<Address> invalidationAddresses;
        int nodes;
        if (this.trace) {
            log.tracef("Invalidating L1 caches for keys %s", keys);
        }
        if ((nodes = (invalidationAddresses = this.buildInvalidationAddressList(keys, origin, assumeOriginKeptEntryInL1)).size()) > 0) {
            boolean multicast = this.isUseMulticast(nodes);
            if (this.trace) {
                log.tracef("There are %s nodes involved in invalidation. Threshold is: %s; using multicast: %s", nodes, this.threshold, multicast);
            }
            if (multicast) {
                if (this.trace) {
                    log.tracef("Invalidating keys %s via multicast", keys);
                }
                final InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(origin, false, InfinispanCollections.<Flag>emptySet(), keys);
                if (useNotifyingFuture) {
                    AggregatingNotifyingFutureImpl<Object> future = new AggregatingNotifyingFutureImpl<Object>(retval, 2);
                    this.rpcManager.invokeRemotelyInFuture(null, (ReplicableCommand)ic, this.rpcManager.getDefaultRpcOptions(true), future);
                    return future;
                }
                return this.asyncTransportExecutor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        L1ManagerImpl.this.rpcManager.invokeRemotely(null, (ReplicableCommand)ic, L1ManagerImpl.this.rpcManager.getDefaultRpcOptions(true));
                        return retval;
                    }
                });
            }
            final SingleRpcCommand rpc = this.commandsFactory.buildSingleRpcCommand(this.commandsFactory.buildInvalidateFromL1Command(origin, false, InfinispanCollections.<Flag>emptySet(), keys));
            if (this.trace) {
                log.tracef("Keys %s needs invalidation on %s", keys, invalidationAddresses);
            }
            if (useNotifyingFuture) {
                AggregatingNotifyingFutureImpl<Object> future = new AggregatingNotifyingFutureImpl<Object>(retval, 2);
                this.rpcManager.invokeRemotelyInFuture(invalidationAddresses, (ReplicableCommand)rpc, this.syncIgnoreLeaversRpcOptions, future);
                return future;
            }
            return this.asyncTransportExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    L1ManagerImpl.this.rpcManager.invokeRemotely((Collection<Address>)invalidationAddresses, (ReplicableCommand)rpc, L1ManagerImpl.this.syncRpcOptions);
                    return retval;
                }
            });
        }
        if (this.trace) {
            log.trace("No L1 caches to invalidate");
        }
        return useNotifyingFuture ? new NotifyingFutureImpl<Object>(retval) : new NoOpFuture<Object>(retval);
    }

    private Collection<Address> buildInvalidationAddressList(Collection<Object> keys, Address origin, boolean assumeOriginKeptEntryInL1) {
        HashSet<Address> addresses = new HashSet<Address>(2);
        boolean originIsInRequestorsList = false;
        for (Object key : keys) {
            ConcurrentMap as = (ConcurrentMap)this.requestors.remove(key);
            if (as == null) continue;
            Set requestorAddresses = as.keySet();
            addresses.addAll(requestorAddresses);
            if (!assumeOriginKeptEntryInL1 || origin == null || !requestorAddresses.contains(origin)) continue;
            originIsInRequestorsList = true;
            this.addRequestor(key, origin);
        }
        if (originIsInRequestorsList) {
            addresses.remove(origin);
        }
        return addresses;
    }

    private boolean isUseMulticast(int nodes) {
        if (this.threshold == -1) {
            return false;
        }
        if (!this.rpcManager.getTransport().isMulticastCapable()) {
            return false;
        }
        if (this.threshold == 0) {
            return true;
        }
        return nodes > this.threshold;
    }
}

