/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong hitTimes = new AtomicLong(0L);
    private final AtomicLong missTimes = new AtomicLong(0L);
    private final AtomicLong storeTimes = new AtomicLong(0L);
    private final AtomicLong removeTimes = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong stores = new AtomicLong(0L);
    private final AtomicLong evictions = new AtomicLong(0L);
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final AtomicLong removeHits = new AtomicLong(0L);
    private final AtomicLong removeMisses = new AtomicLong(0L);
    private DataContainer dataContainer;
    private TimeService timeService;
    private Configuration configuration;
    private static final Log log = LogFactory.getLog(CacheMgmtInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(DataContainer dataContainer, TimeService timeService) {
        this.dataContainer = dataContainer;
        this.timeService = timeService;
    }

    @Start
    public void start() {
        this.startNanoseconds.set(this.timeService.time());
        this.resetNanoseconds.set(this.startNanoseconds.get());
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.getStatisticsEnabled(command)) {
            this.evictions.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            if (ctx.isOriginLocal()) {
                if (retval == null) {
                    this.missTimes.getAndAdd(intervalMilliseconds);
                    this.misses.incrementAndGet();
                } else {
                    this.hitTimes.getAndAdd(intervalMilliseconds);
                    this.hits.incrementAndGet();
                }
            }
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            Map<Object, Object> data = command.getMap();
            if (data != null && ctx.isOriginLocal() && !data.isEmpty()) {
                this.storeTimes.getAndAdd(intervalMilliseconds);
                this.stores.getAndAdd(data.size());
            }
        }
        return retval;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal() && command.isSuccessful()) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            this.storeTimes.getAndAdd(intervalMilliseconds);
            this.stores.incrementAndGet();
        }
        return retval;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal()) {
            if (retval == null) {
                this.removeMisses.incrementAndGet();
            } else {
                long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
                this.removeTimes.getAndAdd(intervalMilliseconds);
                this.removeHits.incrementAndGet();
            }
        }
        return retval;
    }

    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.hits.get();
    }

    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.misses.get();
    }

    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.removeHits.get();
    }

    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.removeMisses.get();
    }

    @ManagedAttribute(description="number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.stores.get();
    }

    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.evictions.get();
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        long hitsL = this.hits.get();
        double total = hitsL + this.misses.get();
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        if (this.stores.get() == 0L) {
            return 0.0;
        }
        return (double)(this.hits.get() + this.misses.get()) / (double)this.stores.get();
    }

    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache", displayName="Average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long total = this.hits.get() + this.misses.get();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.get() + this.missTimes.get()) / total;
    }

    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache", displayName="Average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        if (this.stores.get() == 0L) {
            return 0L;
        }
        return this.storeTimes.get() / this.stores.get();
    }

    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache", displayName="Average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.removeTimes.get() / removes;
    }

    @ManagedAttribute(description="Number of entries currently in the cache", displayName="Number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.dataContainer.size();
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getElapsedTime() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.stores.set(0L);
        this.evictions.set(0L);
        this.hitTimes.set(0L);
        this.missTimes.set(0L);
        this.storeTimes.set(0L);
        this.removeHits.set(0L);
        this.removeMisses.set(0L);
        this.resetNanoseconds.set(this.timeService.time());
    }

    private boolean getStatisticsEnabled(FlagAffectedCommand cmd) {
        return super.getStatisticsEnabled() && !cmd.hasFlag(Flag.SKIP_STATISTICS);
    }
}

