/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.CollectionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheStore", description="Component that handles storing of entries to a CacheStore from memory.")
public class CacheStoreInterceptor
extends JmxStatsCommandInterceptor {
    LoadersConfiguration loaderConfig = null;
    private Map<GlobalTransaction, Integer> txStores;
    private Map<GlobalTransaction, Set<Object>> preparingTxs;
    final AtomicLong cacheStores = new AtomicLong(0L);
    CacheStore store;
    private CacheLoaderManager loaderManager;
    private InternalEntryFactory entryFactory;
    private TransactionManager transactionManager;
    protected volatile boolean enabled = true;
    private static final Log log = LogFactory.getLog(CacheStoreInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void init(CacheLoaderManager loaderManager, InternalEntryFactory entryFactory, TransactionManager transactionManager) {
        this.loaderManager = loaderManager;
        this.entryFactory = entryFactory;
        this.transactionManager = transactionManager;
    }

    @Start(priority=15)
    protected void start() {
        this.store = this.loaderManager.getCacheStore();
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
        this.loaderConfig = this.cacheConfiguration.loaders();
        int concurrencyLevel = this.cacheConfiguration.locking().concurrencyLevel();
        this.txStores = CollectionFactory.makeConcurrentMap(64, concurrencyLevel);
        this.preparingTxs = CollectionFactory.makeConcurrentMap(64, concurrencyLevel);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.isStoreEnabled()) {
            this.commitCommand(ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitCommand(TxInvocationContext ctx) throws Throwable {
        if (!ctx.getCacheTransaction().getAllModifications().isEmpty()) {
            GlobalTransaction tx = ctx.getGlobalTransaction();
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Calling loader.commit() for transaction %s", tx);
            }
            Transaction xaTx = null;
            if (this.transactionManager != null) {
                xaTx = this.transactionManager.suspend();
            }
            try {
                this.store.commit(tx);
            }
            finally {
                this.preparingTxs.remove(tx);
                if (this.transactionManager != null && xaTx != null) {
                    this.transactionManager.resume(xaTx);
                }
            }
            if (this.getStatisticsEnabled()) {
                Integer puts = this.txStores.get(tx);
                if (puts != null) {
                    this.cacheStores.getAndAdd(puts.intValue());
                }
                this.txStores.remove(tx);
            }
        } else if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Commit called with no modifications; ignoring.");
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.isStoreEnabled()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            if (!ctx.getCacheTransaction().getAllModifications().isEmpty()) {
                GlobalTransaction tx = ctx.getGlobalTransaction();
                if (this.preparingTxs.containsKey(tx)) {
                    this.preparingTxs.remove(tx);
                    this.store.rollback(tx);
                }
                if (this.getStatisticsEnabled()) {
                    this.txStores.remove(tx);
                }
            } else if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Rollback called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.isStoreEnabled()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            this.prepareCacheLoader(ctx, command.getGlobalTransaction(), ctx, command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return retval;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return retval;
        }
        Object key = command.getKey();
        boolean resp = this.store.remove(key);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
        }
        return retval;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.isStoreEnabled(command) && !ctx.isInTxScope() && this.isProperWriterForClear(ctx)) {
            this.clearCacheStore();
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected void clearCacheStore() throws CacheLoaderException {
        this.store.clear();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Cleared cache store");
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            if (!this.isProperWriter(ctx, command, key)) continue;
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            if (!this.getLog().isTraceEnabled()) continue;
            this.getLog().tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    protected final void prepareCacheLoader(TxInvocationContext ctx, GlobalTransaction gtx, TxInvocationContext transactionContext, boolean onePhase) throws Throwable {
        if (transactionContext == null) {
            throw new Exception("transactionContext for transaction " + gtx + " not found in transaction table");
        }
        List<WriteCommand> modifications = transactionContext.getCacheTransaction().getAllModifications();
        if (modifications.isEmpty()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Cache loader modification list: %s", modifications);
        }
        StoreModificationsBuilder modsBuilder = new StoreModificationsBuilder(this.getStatisticsEnabled(), modifications.size());
        for (WriteCommand cacheCommand : modifications) {
            if (!this.isStoreEnabled(cacheCommand)) continue;
            cacheCommand.acceptVisitor(ctx, modsBuilder);
        }
        int numMods = modsBuilder.modifications.size();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Converted method calls to cache loader modifications.  List size: %s", numMods);
        }
        if (numMods > 0) {
            boolean shouldCountStores;
            GlobalTransaction tx = transactionContext.getGlobalTransaction();
            this.store.prepare(modsBuilder.modifications, tx, onePhase);
            boolean bl = shouldCountStores = this.getStatisticsEnabled() && modsBuilder.putCount > 0;
            if (!onePhase) {
                this.preparingTxs.put(tx, modsBuilder.affectedKeys);
                if (shouldCountStores) {
                    this.txStores.put(tx, modsBuilder.putCount);
                }
            } else if (shouldCountStores) {
                this.cacheStores.getAndAdd(modsBuilder.putCount);
            }
        }
    }

    protected boolean isStoreEnabled() {
        if (!this.enabled) {
            return false;
        }
        if (this.store == null) {
            log.trace("Skipping cache store because the cache loader does not implement CacheStore");
            return false;
        }
        return true;
    }

    protected boolean isStoreEnabled(FlagAffectedCommand command) {
        if (!this.isStoreEnabled()) {
            return false;
        }
        if (command.hasFlag(Flag.SKIP_CACHE_STORE)) {
            log.trace("Skipping cache store since the call contain a skip cache store flag");
            return false;
        }
        if (this.loaderConfig.shared() && command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE)) {
            log.trace("Skipping cache store since it is shared and the call contain a skip shared cache store flag");
            return false;
        }
        return true;
    }

    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        return !this.loaderConfig.shared() || ctx.isOriginLocal();
    }

    protected boolean isProperWriterForClear(InvocationContext ctx) {
        return true;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.cacheStores.set(0L);
    }

    @ManagedAttribute(description="number of cache loader stores", displayName="Number of cache stores", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderStores() {
        return this.cacheStores.get();
    }

    InternalCacheEntry getStoredEntry(Object key, InvocationContext ctx) {
        EntryVersion version;
        EntryVersionsMap updatedVersions;
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return (InternalCacheEntry)entry;
        }
        if (ctx.isInTxScope() && (updatedVersions = ((TxInvocationContext)ctx).getCacheTransaction().getUpdatedEntryVersions()) != null && (version = (EntryVersion)updatedVersions.get(entry.getKey())) != null) {
            Metadata metadata = entry.getMetadata();
            if (metadata == null) {
                metadata = new EmbeddedMetadata.Builder().lifespan(entry.getLifespan()).maxIdle(entry.getMaxIdle()).version(version).build();
                return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata);
            }
            metadata = metadata.builder().version(version).build();
            return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata);
        }
        return this.entryFactory.create(entry);
    }

    public void disableInterceptor() {
        this.enabled = false;
    }

    public Map<GlobalTransaction, Set<Object>> getPreparingTxs() {
        return Collections.unmodifiableMap(this.preparingTxs);
    }

    public Map<GlobalTransaction, Integer> getTxStores() {
        return Collections.unmodifiableMap(this.txStores);
    }

    public class StoreModificationsBuilder
    extends AbstractVisitor {
        private final boolean generateStatistics;
        int putCount;
        private final Set<Object> affectedKeys;
        private final List<Modification> modifications;

        public StoreModificationsBuilder(boolean generateStatistics, int numMods) {
            this.generateStatistics = generateStatistics;
            this.affectedKeys = new HashSet<Object>(numMods);
            this.modifications = new ArrayList<Modification>(numMods);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (CacheStoreInterceptor.this.isProperWriter(ctx, command, command.getKey())) {
                InternalCacheEntry ice;
                CacheEntry entry;
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                if ((entry = ctx.lookupEntry(command.getKey())) instanceof InternalCacheEntry) {
                    ice = (InternalCacheEntry)entry;
                } else if (entry instanceof DeltaAwareCacheEntry) {
                    AtomicHashMap<?, ?> uncommittedChanges = ((DeltaAwareCacheEntry)entry).getUncommittedChages();
                    ice = CacheStoreInterceptor.this.entryFactory.create(entry.getKey(), uncommittedChanges, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
                } else {
                    ice = CacheStoreInterceptor.this.entryFactory.create(entry);
                }
                this.modifications.add(new Store(ice));
                this.affectedKeys.add(command.getKey());
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map<Object, Object> map = command.getMap();
            for (Object key : map.keySet()) {
                this.visitSingleStore(ctx, command, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            Object key = command.getKey();
            if (CacheStoreInterceptor.this.isProperWriter(ctx, command, key)) {
                this.modifications.add(new Remove(key));
                this.affectedKeys.add(command.getKey());
            }
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            if (CacheStoreInterceptor.this.isProperWriterForClear(ctx)) {
                this.modifications.add(new Clear());
            }
            return null;
        }

        private Object visitSingleStore(InvocationContext ctx, FlagAffectedCommand command, Object key) throws Throwable {
            if (CacheStoreInterceptor.this.isProperWriter(ctx, command, key)) {
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                this.modifications.add(new Store(CacheStoreInterceptor.this.getStoredEntry(key, ctx)));
                this.affectedKeys.add(key);
            }
            return null;
        }
    }
}

