/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTransport
implements Transport {
    protected GlobalConfiguration configuration;

    @Inject
    public void setConfiguration(GlobalConfiguration globalConfiguration) {
        this.configuration = globalConfiguration;
    }

    private boolean shouldThrowException(Exception ce) {
        if (!this.configuration.transport().strictPeerToPeer()) {
            if (ce instanceof NamedCacheNotFoundException) {
                return false;
            }
            if (ce.getCause() != null && ce.getCause() instanceof NamedCacheNotFoundException) {
                return false;
            }
        }
        return true;
    }

    public final boolean checkResponse(Object responseObject, Address sender) throws Exception {
        Log log = this.getLog();
        if (responseObject instanceof Response) {
            Response response = (Response)responseObject;
            if (response instanceof ExceptionResponse) {
                ExceptionResponse exceptionResponse = (ExceptionResponse)response;
                Exception e = exceptionResponse.getException();
                if (this.shouldThrowException(e)) {
                    throw log.remoteException(sender, e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Received exception from " + sender, e);
                }
            }
            return true;
        }
        if (responseObject != null) {
            Class<?> responseClass = responseObject.getClass();
            log.tracef("Unexpected response object type from %s: %s", sender, responseClass);
            throw new CacheException(String.format("Unexpected response object type from %s: %s", sender, responseClass));
        }
        return false;
    }

    protected final boolean parseResponseAndAddToResponseList(Object responseObject, Throwable exception, Map<Address, Response> responseListToAddTo, boolean wasSuspected, boolean wasReceived, Address sender, boolean usedResponseFilter, boolean ignoreLeavers) throws Exception {
        Log log = this.getLog();
        boolean invalidResponse = true;
        if (!wasSuspected && wasReceived) {
            invalidResponse = false;
            if (exception != null) {
                log.tracef(exception, "Unexpected exception from %s", sender);
                throw new CacheException("Remote (" + sender + ") failed unexpectedly", exception);
            }
            if (this.checkResponse(responseObject, sender)) {
                responseListToAddTo.put(sender, (Response)responseObject);
            }
        } else if (wasSuspected) {
            if (!ignoreLeavers) {
                throw new SuspectException("Suspected member: " + sender, sender);
            }
            log.tracef("Target node %s left during remote call, ignoring", sender);
            invalidResponse = false;
        } else if (!usedResponseFilter) {
            throw new TimeoutException("Replication timeout for " + sender);
        }
        return invalidResponse;
    }
}

