/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.util.Immutables;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheStatus {
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private static boolean trace = log.isTraceEnabled();
    private final String cacheName;
    private final CacheJoinInfo joinInfo;
    private volatile List<Address> members;
    private volatile List<Address> joiners;
    private volatile CacheTopology cacheTopology;
    private volatile RebalanceConfirmationCollector rebalanceStatus;

    public ClusterCacheStatus(String cacheName, CacheJoinInfo joinInfo) {
        this.cacheName = cacheName;
        this.joinInfo = joinInfo;
        this.cacheTopology = new CacheTopology(-1, null, null);
        this.members = InfinispanCollections.emptyList();
        this.joiners = InfinispanCollections.emptyList();
        if (trace) {
            log.tracef("Cache %s initialized, join info is %s", cacheName, joinInfo);
        }
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public List<Address> getJoiners() {
        return this.joiners;
    }

    public boolean hasJoiners() {
        return !this.joiners.isEmpty();
    }

    public boolean isTotalOrder() {
        return this.joinInfo.isTotalOrder();
    }

    public boolean isDistributed() {
        return this.joinInfo.isDistributed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.members = Immutables.immutableListCopy(newMembers);
            ConsistentHash currentCH = this.cacheTopology.getCurrentCH();
            this.joiners = currentCH != null ? this.immutableRemoveAll(this.members, currentCH.getMembers()) : this.members;
            if (trace) {
                log.tracef("Cache %s members list updated, members = %s, joiners = %s", this.cacheName, this.members, this.joiners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(Address joiner) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.members.contains(joiner)) {
                if (trace) {
                    log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.members, this.joiners});
                }
                return false;
            }
            this.members = this.immutableAdd(this.members, joiner);
            this.joiners = this.immutableAdd(this.joiners, joiner);
            if (trace) {
                log.tracef("Added joiner %s to cache %s: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.members, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(Address leaver) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (!this.members.contains(leaver)) {
                if (trace) {
                    log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", leaver, this.cacheName, this.members);
                }
                return false;
            }
            this.members = this.immutableRemove(this.members, leaver);
            this.joiners = this.immutableRemove(this.joiners, leaver);
            if (trace) {
                log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", new Object[]{leaver, this.cacheName, this.members, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateClusterMembers(List<Address> newClusterMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newClusterMembers.containsAll(this.members)) {
                if (trace) {
                    log.tracef("Cluster members updated for cache %s, no leavers detected: cache members = %s", this.cacheName, newClusterMembers);
                }
                return false;
            }
            this.members = this.immutableRetainAll(this.members, newClusterMembers);
            this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
            if (trace) {
                log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", this.cacheName, this.members, this.joiners);
            }
            return true;
        }
    }

    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.cacheTopology = newTopology;
            if (!this.members.containsAll(this.cacheTopology.getMembers())) {
                throw new IllegalStateException(String.format("Trying to set a topology with invalid members for cache %s: members = %s, topology = %s", this.cacheName, this.members, this.cacheTopology));
            }
            if (newTopology.getCurrentCH() != null) {
                this.joiners = this.immutableRemoveAll(this.members, newTopology.getCurrentCH().getMembers());
            }
            if (trace) {
                log.tracef("Cache %s topology updated: members = %s, joiners = %s, topology = %s", new Object[]{this.cacheName, this.members, this.joiners, this.cacheTopology});
            }
        }
    }

    public boolean needConsistentHashUpdate() {
        return !this.members.containsAll(this.cacheTopology.getMembers());
    }

    public List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.members);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRebalance(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus != null) {
                return false;
            }
            this.rebalanceStatus = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers());
            this.cacheTopology = newTopology;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmRebalanceOnNode(Address member, int receivedTopologyId) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.confirmRebalance(member, receivedTopologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRebalanceMembersList() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.updateMembers(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                throw new IllegalStateException("Can't end rebalance, there is no rebalance in progress");
            }
            this.rebalanceStatus = null;
        }
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.members + ", joiners=" + this.joiners + ", cacheTopology=" + this.cacheTopology + ", rebalanceStatus=" + this.rebalanceStatus + '}';
    }
}

