/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class LoaderHelper {
    private static final List<Class> objectNotFoundExceptions = new ArrayList<Class>(2);

    private LoaderHelper() {
    }

    public static boolean isObjectNotFoundException(RuntimeException e) {
        boolean objectNotFound = false;
        Class<?> exceptionClass = e.getClass();
        for (Class clazz : objectNotFoundExceptions) {
            if (!clazz.isAssignableFrom(exceptionClass)) continue;
            objectNotFound = true;
            break;
        }
        return objectNotFound;
    }

    static {
        try {
            objectNotFoundExceptions.add(ClassLoaderHelper.classForName((String)"org.hibernate.ObjectNotFoundException", (ClassLoader)LoaderHelper.class.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            objectNotFoundExceptions.add(ClassLoaderHelper.classForName((String)"javax.persistence.EntityNotFoundException", (ClassLoader)LoaderHelper.class.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

