/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerServiceProvider;
import org.hibernate.search.infinispan.InfinispanIntegration;
import org.hibernate.search.infinispan.impl.AsyncDeleteExecutorService;
import org.hibernate.search.infinispan.impl.DefaultAsyncDeleteExecutorServiceProvider;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    @Deprecated
    public static final String DEFAULT_LOCKING_CACHENAME = "LuceneIndexesLocking";
    @Deprecated
    public static final String DEFAULT_INDEXESDATA_CACHENAME = "LuceneIndexesData";
    @Deprecated
    public static final String DEFAULT_INDEXESMETADATA_CACHENAME = "LuceneIndexesLocking";
    private ServiceManager serviceManager;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private Integer chunkSize;
    private Directory directory;
    private EmbeddedCacheManager cacheManager;
    private LockFactory indexWriterLockFactory;
    private AsyncDeleteExecutorService deletesExecutor;

    public void initialize(String directoryProviderName, Properties properties, org.hibernate.search.spi.BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.cacheManager = (EmbeddedCacheManager)this.serviceManager.requestService(CacheManagerServiceProvider.class, context);
        this.deletesExecutor = (AsyncDeleteExecutorService)this.serviceManager.requestService(DefaultAsyncDeleteExecutorServiceProvider.class, context);
        this.metadataCacheName = InfinispanIntegration.getMetadataCacheName(properties);
        this.dataCacheName = InfinispanIntegration.getDataCacheName(properties);
        this.lockingCacheName = InfinispanIntegration.getLockingCacheName(properties);
        this.chunkSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"chunk_size");
        if (DirectoryProviderHelper.configurationExplicitlySetsLockFactory((Properties)properties)) {
            File verifiedIndexDir = null;
            if (DirectoryProviderHelper.isNativeLockingStrategy((Properties)properties)) {
                verifiedIndexDir = DirectoryProviderHelper.getVerifiedIndexDir((String)directoryProviderName, (Properties)properties, (boolean)true);
            }
            this.indexWriterLockFactory = DirectoryProviderHelper.createLockFactory(verifiedIndexDir, (Properties)properties);
        }
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        log.debug("Starting InfinispanDirectory");
        this.cacheManager.startCaches(new String[]{this.metadataCacheName, this.dataCacheName, this.lockingCacheName});
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        BuildContext directoryBuildContext = DirectoryBuilder.newDirectoryInstance((Cache)metadataCache, (Cache)dataCache, (Cache)lockingCache, (String)this.directoryProviderName);
        this.augmentDirectoryWithAsyncDeletes(directoryBuildContext);
        if (this.chunkSize != null) {
            directoryBuildContext.chunkSize(this.chunkSize.intValue());
        }
        if (this.indexWriterLockFactory != null) {
            directoryBuildContext.overrideWriteLocker(this.indexWriterLockFactory);
        }
        this.directory = directoryBuildContext.create();
        DirectoryProviderHelper.initializeIndexIfNeeded((Directory)this.directory);
        log.debugf("Initialized Infinispan index: '%s'", this.directoryProviderName);
    }

    private void augmentDirectoryWithAsyncDeletes(BuildContext directoryBuildContext) {
        Executor executor = this.deletesExecutor.getExecutor();
        try {
            Method operationsExecutor = directoryBuildContext.getClass().getMethod("deleteOperationsExecutor", Executor.class);
            operationsExecutor.invoke((Object)directoryBuildContext, executor);
        }
        catch (NoSuchMethodException e) {
            log.asyncDeletesNotSupported();
        }
        catch (InvocationTargetException e) {
            log.asyncDeletesInvocationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.asyncDeletesIllegalAccess(e.getMessage());
        }
    }

    public void stop() {
        this.deletesExecutor.closeAndFlush();
        this.serviceManager.releaseService(DefaultAsyncDeleteExecutorServiceProvider.class);
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.unableToCloseLuceneDirectory(this.directory, e);
        }
        this.serviceManager.releaseService(CacheManagerServiceProvider.class);
        log.debug("Stopped InfinispanDirectory");
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

