/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.service.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.AggregatedClassLoader;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class StandardServiceManager
implements ServiceManager {
    private static final Log log = LoggerFactory.make();
    private final Properties properties;
    private final BuildContext buildContext;
    private AggregatedClassLoader aggregatedClassLoader;
    private final ConcurrentHashMap<Class<?>, ServiceWrapper<?>> cachedServices = new ConcurrentHashMap();
    private final Map<Class<? extends Service>, Object> providedServices;

    public StandardServiceManager(SearchConfiguration cfg, BuildContext buildContext) {
        this.properties = cfg.getProperties();
        this.providedServices = Collections.unmodifiableMap(cfg.getProvidedServices());
        this.buildContext = buildContext;
        this.aggregatedClassLoader = new AggregatedClassLoader(Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader());
    }

    @Override
    public <S extends Service> S requestService(Class<S> serviceRole) {
        if (serviceRole == null) {
            throw new IllegalArgumentException("'null' is not a valid service role");
        }
        if (this.providedServices.containsKey(serviceRole)) {
            return (S)((Service)this.providedServices.get(serviceRole));
        }
        ServiceWrapper<Object> wrapper = this.cachedServices.get(serviceRole);
        if (wrapper == null) {
            wrapper = this.createAndCacheWrapper(serviceRole);
        }
        wrapper.startVirtual();
        return (S)((Service)wrapper.getService());
    }

    @Override
    public <S extends Service> void releaseService(Class<S> serviceRole) {
        if (serviceRole == null) {
            throw new IllegalArgumentException("'null' is not a valid service role");
        }
        if (this.providedServices.containsKey(this.providedServices)) {
            return;
        }
        ServiceWrapper<?> wrapper = this.cachedServices.get(serviceRole);
        if (wrapper != null) {
            wrapper.stopVirtual();
        }
    }

    @Override
    public void releaseAllServices() {
        for (ServiceWrapper<?> wrapper : this.cachedServices.values()) {
            wrapper.ensureStopped();
        }
    }

    private <S extends Service> Set<S> loadJavaServices(Class<S> serviceContract) {
        ServiceLoader<Service> serviceLoader = ServiceLoader.load(serviceContract, this.aggregatedClassLoader);
        LinkedHashSet<Service> services = new LinkedHashSet<Service>();
        for (Service service : serviceLoader) {
            services.add(service);
        }
        return services;
    }

    private <S extends Service> ServiceWrapper<S> createAndCacheWrapper(Class<S> serviceRole) {
        Set<S> services = this.loadJavaServices(serviceRole);
        if (services.size() == 0) {
            throw log.getNoServiceImplementationFoundException(serviceRole.toString());
        }
        if (services.size() > 1) {
            throw log.getMultipleServiceImplementationsException(serviceRole.toString(), StringHelper.join(services, ","));
        }
        ServiceWrapper<S> wrapper = new ServiceWrapper<S>(services.iterator().next(), serviceRole, this.buildContext);
        ServiceWrapper<S> previousWrapper = this.cachedServices.putIfAbsent(serviceRole, wrapper);
        if (previousWrapper != null) {
            wrapper = previousWrapper;
        }
        return wrapper;
    }

    private static enum ServiceStatus {
        RUNNING,
        STOPPED,
        STARTING,
        STOPPING;

    }

    private class ServiceWrapper<S> {
        private final S service;
        private final BuildContext context;
        private final Class<S> serviceClass;
        private int userCounter = 0;
        private ServiceStatus status = ServiceStatus.STOPPED;

        ServiceWrapper(S service, Class<S> serviceClass, BuildContext context) {
            this.service = service;
            this.context = context;
            this.serviceClass = serviceClass;
        }

        synchronized S getService() {
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
            return this.service;
        }

        synchronized void startVirtual() {
            int previousValue;
            if ((previousValue = this.userCounter++) == 0) {
                if (this.status != ServiceStatus.STOPPED) {
                    this.stateExpectedFailure();
                }
                this.startService(this.service);
            }
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
        }

        synchronized void stopVirtual() {
            --this.userCounter;
            if (this.userCounter == 0) {
                if (this.status != ServiceStatus.RUNNING) {
                    this.stateExpectedFailure();
                }
                this.stopAndRemoveFromCache();
            } else if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
        }

        synchronized void ensureStopped() {
            if (this.status != ServiceStatus.STOPPED) {
                log.serviceProviderNotReleased(this.serviceClass);
                this.stopAndRemoveFromCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAndRemoveFromCache() {
            this.status = ServiceStatus.STOPPING;
            try {
                if (this.service instanceof Stoppable) {
                    ((Stoppable)this.service).stop();
                }
            }
            catch (Exception e) {
                log.stopServiceFailed(this.serviceClass, e);
            }
            finally {
                this.status = ServiceStatus.STOPPED;
                StandardServiceManager.this.cachedServices.remove(this.serviceClass);
            }
        }

        private void startService(S service) {
            this.status = ServiceStatus.STARTING;
            if (service instanceof Startable) {
                ((Startable)service).start(StandardServiceManager.this.properties, this.context);
            }
            this.status = ServiceStatus.RUNNING;
        }

        private void stateExpectedFailure() {
            throw log.getUnexpectedServiceStatusException(this.status.name(), this.service.toString());
        }
    }
}

