/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NotSharedReaderProvider
implements DirectoryBasedReaderProvider {
    private static final Log log = LoggerFactory.make();
    private DirectoryProvider directoryProvider;
    private String indexName;

    public DirectoryReader openIndexReader() {
        Object directory = this.directoryProvider.getDirectory();
        try {
            return DirectoryReader.open(directory);
        }
        catch (IOException e) {
            throw new SearchException("Could not open index \"" + this.indexName + "\"", e);
        }
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            log.unableToCloseLuceneIndexReader(e);
        }
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
        this.directoryProvider = indexManager.getDirectoryProvider();
        this.indexName = indexManager.getIndexName();
    }

    @Override
    public void stop() {
    }
}

