/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.MoreLikeThisTermination;
import org.hibernate.search.query.dsl.MoreLikeThisToEntityContentAndTermination;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.MoreLikeThisBuilder;
import org.hibernate.search.query.dsl.impl.MoreLikeThisQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class ConnectedMoreLikeThisQueryBuilder {
    private static final Log log = LoggerFactory.make();
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final FieldsContext fieldsContext;
    private final INPUT_TYPE inputType;
    private final Object input;
    private final MoreLikeThisQueryContext moreLikeThisContext;

    public ConnectedMoreLikeThisQueryBuilder(Object id, INPUT_TYPE inputType, FieldsContext fieldsContext, MoreLikeThisQueryContext moreLikeThisContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.moreLikeThisContext = moreLikeThisContext;
        this.fieldsContext = fieldsContext;
        this.inputType = inputType;
        this.input = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery() {
        Query query;
        SearchFactoryImplementor searchFactory = this.queryContext.getFactory();
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        IndexReader indexReader = searchFactory.getIndexReaderAccessor().open(this.queryContext.getEntityType());
        try {
            String[] fieldNames = this.getAllCompatibleFieldNames(documentBuilder);
            if (this.fieldsContext.size() == 0) {
                this.fieldsContext.addAll(fieldNames);
            }
            query = new MoreLikeThisBuilder(documentBuilder, searchFactory).compatibleFieldNames(fieldNames).fieldsContext(this.fieldsContext).queryContext(this.queryContext).indexReader(indexReader).inputType(this.inputType).input(this.input).otherMoreLikeThisContext(this.moreLikeThisContext).createQuery();
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(indexReader);
        }
        return this.queryCustomizer.setWrappedQuery(query).createQuery();
    }

    private String[] getAllCompatibleFieldNames(DocumentBuilderIndexedEntity<?> documentBuilder) {
        Collection<DocumentFieldMetadata> allFieldMetadata = documentBuilder.getTypeMetadata().getAllDocumentFieldMetadata();
        ArrayList<String> fieldNames = new ArrayList<String>(allFieldMetadata.size());
        for (DocumentFieldMetadata fieldMetadata : allFieldMetadata) {
            if (fieldMetadata.getTermVector() == Field.TermVector.NO && fieldMetadata.getStore() == Store.NO || fieldMetadata.isId()) continue;
            fieldNames.add(fieldMetadata.getName());
        }
        if (fieldNames.size() == 0) {
            throw log.noFieldCompatibleForMoreLikeThis(documentBuilder.getBeanClass());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public static final class MoreLikeThisToEntityContentAndTerminationImpl
    extends ConnectedMoreLikeThisQueryBuilder
    implements MoreLikeThisToEntityContentAndTermination {
        public MoreLikeThisToEntityContentAndTerminationImpl(Object id, INPUT_TYPE inputType, FieldsContext fieldsContext, MoreLikeThisQueryContext moreLikeThisContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
            super(id, inputType, fieldsContext, moreLikeThisContext, queryCustomizer, queryContext);
        }
    }

    public static final class MoreLikeThisTerminationImpl
    extends ConnectedMoreLikeThisQueryBuilder
    implements MoreLikeThisTermination {
        public MoreLikeThisTerminationImpl(Object id, INPUT_TYPE inputType, FieldsContext fieldsContext, MoreLikeThisQueryContext moreLikeThisContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
            super(id, inputType, fieldsContext, moreLikeThisContext, queryCustomizer, queryContext);
        }
    }

    public static enum INPUT_TYPE {
        ID,
        ENTITY,
        READER,
        STRING;

    }
}

