/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.facet.collections.IntToDoubleMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceComparator
extends FieldComparator<Double> {
    private final Point center;
    private final String latitudeField;
    private final String longitudeField;
    private IntToDoubleMap distances;
    private IntToDoubleMap latitudeValues;
    private IntToDoubleMap longitudeValues;
    private Double bottomDistance;
    private int docBase = 0;

    public DistanceComparator(Point center, int hitsCount, String fieldname) {
        this.center = center;
        this.distances = new IntToDoubleMap(hitsCount);
        this.latitudeValues = new IntToDoubleMap(hitsCount);
        this.longitudeValues = new IntToDoubleMap(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.distances.get(slot1), this.distances.get(slot2));
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.distances.get(slot);
    }

    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottomDistance, this.center.getDistanceTo(this.latitudeValues.get(this.docBase + doc), this.longitudeValues.get(this.docBase + doc)));
    }

    public void copy(int slot, int doc) throws IOException {
        this.distances.put(slot, this.center.getDistanceTo(this.latitudeValues.get(this.docBase + doc), this.longitudeValues.get(this.docBase + doc)));
    }

    public DistanceComparator setNextReader(AtomicReaderContext newContext) throws IOException {
        AtomicReader atomicReader = newContext.reader();
        FieldCache.Doubles unbasedLatitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.latitudeField, false);
        FieldCache.Doubles unbasedLongitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.longitudeField, false);
        this.docBase = newContext.docBase;
        int numDocs = atomicReader.numDocs();
        for (int i = 0; i < numDocs; ++i) {
            this.latitudeValues.put(this.docBase + i, unbasedLatitudeValues.get(i));
            this.longitudeValues.put(this.docBase + i, unbasedLongitudeValues.get(i));
        }
        return this;
    }

    public Double value(int slot) {
        return this.center.getDistanceTo(this.latitudeValues.get(slot), this.longitudeValues.get(slot));
    }

    public int compareDocToValue(int doc, Double value) throws IOException {
        if (value == null) {
            return 1;
        }
        double distanceTo = this.center.getDistanceTo(this.latitudeValues.get(doc), this.longitudeValues.get(doc));
        return Double.compare(distanceTo, value);
    }
}

