/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.search.FacetArrays;

public abstract class OrdinalValueResolver {
    protected final FacetArrays arrays;

    protected OrdinalValueResolver(FacetArrays arrays) {
        this.arrays = arrays;
    }

    public abstract double valueOf(int var1);

    public static final class FloatValueResolver
    extends OrdinalValueResolver {
        private final float[] values;

        public FloatValueResolver(FacetArrays arrays) {
            super(arrays);
            this.values = arrays.getFloatArray();
        }

        @Override
        public final double valueOf(int ordinal) {
            return this.values[ordinal];
        }
    }

    public static final class IntValueResolver
    extends OrdinalValueResolver {
        private final int[] values;

        public IntValueResolver(FacetArrays arrays) {
            super(arrays);
            this.values = arrays.getIntArray();
        }

        @Override
        public final double valueOf(int ordinal) {
            return this.values[ordinal];
        }
    }
}

