/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.hibernate.search.SearchException;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class ClassBridge
implements TwoWayStringBridge {
    private final ServiceManager serviceManager;

    public ClassBridge(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Object stringToObject(String stringValue) {
        if (StringHelper.isEmpty(stringValue)) {
            return null;
        }
        try {
            return ClassLoaderHelper.classForName(stringValue, this.serviceManager);
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to deserialize Class: " + stringValue, e);
        }
    }

    @Override
    public String objectToString(Object object) {
        return object == null ? null : ((Class)object).getName();
    }
}

