/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.TikaBridge;
import org.hibernate.search.bridge.AppliedOnTypeAwareBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.BigDecimalBridge;
import org.hibernate.search.bridge.builtin.BigIntegerBridge;
import org.hibernate.search.bridge.builtin.BooleanBridge;
import org.hibernate.search.bridge.builtin.CalendarBridge;
import org.hibernate.search.bridge.builtin.CharacterBridge;
import org.hibernate.search.bridge.builtin.DoubleBridge;
import org.hibernate.search.bridge.builtin.EnumBridge;
import org.hibernate.search.bridge.builtin.FloatBridge;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;
import org.hibernate.search.bridge.builtin.UUIDBridge;
import org.hibernate.search.bridge.builtin.UriBridge;
import org.hibernate.search.bridge.builtin.UrlBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinArrayBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinIterableBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinMapBridge;
import org.hibernate.search.bridge.builtin.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.SpatialFieldBridgeByHash;
import org.hibernate.search.spatial.SpatialFieldBridgeByRange;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class BridgeFactory {
    private static final Log LOG = LoggerFactory.make();
    public final TwoWayFieldBridge CHARACTER = new TwoWayString2FieldBridgeAdaptor(new CharacterBridge());
    public final TwoWayFieldBridge DOUBLE = new TwoWayString2FieldBridgeAdaptor(new DoubleBridge());
    public final TwoWayFieldBridge FLOAT = new TwoWayString2FieldBridgeAdaptor(new FloatBridge());
    public final TwoWayFieldBridge SHORT = new TwoWayString2FieldBridgeAdaptor(new ShortBridge());
    public final TwoWayFieldBridge INTEGER = new TwoWayString2FieldBridgeAdaptor(new IntegerBridge());
    public final TwoWayFieldBridge LONG = new TwoWayString2FieldBridgeAdaptor(new LongBridge());
    public final TwoWayFieldBridge BIG_INTEGER = new TwoWayString2FieldBridgeAdaptor(new BigIntegerBridge());
    public final TwoWayFieldBridge BIG_DECIMAL = new TwoWayString2FieldBridgeAdaptor(new BigDecimalBridge());
    public final TwoWayFieldBridge STRING = new TwoWayString2FieldBridgeAdaptor(new org.hibernate.search.bridge.builtin.StringBridge());
    public final TwoWayFieldBridge BOOLEAN = new TwoWayString2FieldBridgeAdaptor(new BooleanBridge());
    public final TwoWayFieldBridge CLAZZ;
    public final TwoWayFieldBridge Url;
    public final TwoWayFieldBridge Uri;
    public final TwoWayFieldBridge UUID;
    public final FieldBridge DATE_YEAR;
    public final FieldBridge DATE_MONTH;
    public final FieldBridge DATE_DAY;
    public final FieldBridge DATE_HOUR;
    public final FieldBridge DATE_MINUTE;
    public final FieldBridge DATE_SECOND;
    public final FieldBridge ITERABLE_DATE_YEAR;
    public final FieldBridge ITERABLE_DATE_MONTH;
    public final FieldBridge ITERABLE_DATE_DAY;
    public final FieldBridge ITERABLE_DATE_HOUR;
    public final FieldBridge ITERABLE_DATE_MINUTE;
    public final FieldBridge ITERABLE_DATE_SECOND;
    public final FieldBridge MAP_DATE_YEAR;
    public final FieldBridge MAP_DATE_MONTH;
    public final FieldBridge MAP_DATE_DAY;
    public final FieldBridge MAP_DATE_HOUR;
    public final FieldBridge MAP_DATE_MINUTE;
    public final FieldBridge MAP_DATE_SECOND;
    public final FieldBridge ARRAY_DATE_YEAR;
    public final FieldBridge ARRAY_DATE_MONTH;
    public final FieldBridge ARRAY_DATE_DAY;
    public final FieldBridge ARRAY_DATE_HOUR;
    public final FieldBridge ARRAY_DATE_MINUTE;
    public final FieldBridge ARRAY_DATE_SECOND;
    public final FieldBridge CALENDAR_YEAR;
    public final FieldBridge CALENDAR_MONTH;
    public final FieldBridge CALENDAR_DAY;
    public final FieldBridge CALENDAR_HOUR;
    public final FieldBridge CALENDAR_MINUTE;
    public final FieldBridge CALENDAR_SECOND;
    public final FieldBridge ITERABLE_CALENDAR_YEAR;
    public final FieldBridge ITERABLE_CALENDAR_MONTH;
    public final FieldBridge ITERABLE_CALENDAR_DAY;
    public final FieldBridge ITERABLE_CALENDAR_HOUR;
    public final FieldBridge ITERABLE_CALENDAR_MINUTE;
    public final FieldBridge ITERABLE_CALENDAR_SECOND;
    public final FieldBridge MAP_CALENDAR_YEAR;
    public final FieldBridge MAP_CALENDAR_MONTH;
    public final FieldBridge MAP_CALENDAR_DAY;
    public final FieldBridge MAP_CALENDAR_HOUR;
    public final FieldBridge MAP_CALENDAR_MINUTE;
    public final FieldBridge MAP_CALENDAR_SECOND;
    public final FieldBridge ARRAY_CALENDAR_YEAR;
    public final FieldBridge ARRAY_CALENDAR_MONTH;
    public final FieldBridge ARRAY_CALENDAR_DAY;
    public final FieldBridge ARRAY_CALENDAR_HOUR;
    public final FieldBridge ARRAY_CALENDAR_MINUTE;
    public final FieldBridge ARRAY_CALENDAR_SECOND;
    public final FieldBridge ITERABLE_BRIDGE;
    public final BuiltinIterableBridge ITERABLE_BRIDGE_DOUBLE;
    public final BuiltinIterableBridge ITERABLE_BRIDGE_FLOAT;
    public final BuiltinIterableBridge ITERABLE_BRIDGE_INT;
    public final BuiltinIterableBridge ITERABLE_BRIDGE_LONG;
    public final FieldBridge ARRAY_BRIDGE;
    public final BuiltinArrayBridge ARRAY_BRIDGE_DOUBLE;
    public final BuiltinArrayBridge ARRAY_BRIDGE_FLOAT;
    public final BuiltinArrayBridge ARRAY_BRIDGE_INT;
    public final BuiltinArrayBridge ARRAY_BRIDGE_LONG;
    public final FieldBridge MAP_BRIDGE;
    public final BuiltinMapBridge MAP_BRIDGE_DOUBLE;
    public final BuiltinMapBridge MAP_BRIDGE_FLOAT;
    public final BuiltinMapBridge MAP_BRIDGE_INT;
    public final BuiltinMapBridge MAP_BRIDGE_LONG;
    public final TwoWayFieldBridge DATE_MILLISECOND;
    public final FieldBridge ARRAY_DATE_MILLISECOND;
    public final FieldBridge ITERABLE_DATE_MILLISECOND;
    public final FieldBridge MAP_DATE_MILLISECOND;
    public final TwoWayFieldBridge CALENDAR_MILLISECOND;
    public final FieldBridge ARRAY_CALENDAR_MILLISECOND;
    public final FieldBridge ITERABLE_CALENDAR_MILLISECOND;
    public final FieldBridge MAP_CALENDAR_MILLISECOND;
    public final String TIKA_BRIDGE_NAME = "org.hibernate.search.bridge.builtin.TikaBridge";
    public final String TIKA_BRIDGE_METADATA_PROCESSOR_SETTER = "setMetadataProcessorClass";
    public final String TIKA_BRIDGE_PARSE_CONTEXT_SETTER = "setParseContextProviderClass";
    private final Map<String, FieldBridge> builtInBridges;
    private final Map<String, NumericFieldBridge> numericBridges;
    private final Map<String, BuiltinMapBridge> numericMapBridges;
    private final Map<String, BuiltinArrayBridge> numericArrayBridges;
    private final Map<String, BuiltinIterableBridge> numericIterableBridges;

    public BridgeFactory(ServiceManager serviceManager) {
        this.CLAZZ = new TwoWayString2FieldBridgeAdaptor(new org.hibernate.search.bridge.builtin.ClassBridge(serviceManager));
        this.Url = new TwoWayString2FieldBridgeAdaptor(new UrlBridge());
        this.Uri = new TwoWayString2FieldBridgeAdaptor(new UriBridge());
        this.UUID = new TwoWayString2FieldBridgeAdaptor(new UUIDBridge());
        this.DATE_YEAR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_YEAR);
        this.DATE_MONTH = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MONTH);
        this.DATE_DAY = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_DAY);
        this.DATE_HOUR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_HOUR);
        this.DATE_MINUTE = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MINUTE);
        this.DATE_SECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_SECOND);
        this.ITERABLE_DATE_YEAR = new BuiltinIterableBridge(this.DATE_YEAR);
        this.ITERABLE_DATE_MONTH = new BuiltinIterableBridge(this.DATE_MONTH);
        this.ITERABLE_DATE_DAY = new BuiltinIterableBridge(this.DATE_DAY);
        this.ITERABLE_DATE_HOUR = new BuiltinIterableBridge(this.DATE_HOUR);
        this.ITERABLE_DATE_MINUTE = new BuiltinIterableBridge(this.DATE_MINUTE);
        this.ITERABLE_DATE_SECOND = new BuiltinIterableBridge(this.DATE_SECOND);
        this.MAP_DATE_YEAR = new BuiltinMapBridge(this.DATE_YEAR);
        this.MAP_DATE_MONTH = new BuiltinMapBridge(this.DATE_MONTH);
        this.MAP_DATE_DAY = new BuiltinMapBridge(this.DATE_DAY);
        this.MAP_DATE_HOUR = new BuiltinMapBridge(this.DATE_HOUR);
        this.MAP_DATE_MINUTE = new BuiltinMapBridge(this.DATE_MINUTE);
        this.MAP_DATE_SECOND = new BuiltinMapBridge(this.DATE_SECOND);
        this.ARRAY_DATE_YEAR = new BuiltinArrayBridge(this.DATE_YEAR);
        this.ARRAY_DATE_MONTH = new BuiltinArrayBridge(this.DATE_MONTH);
        this.ARRAY_DATE_DAY = new BuiltinArrayBridge(this.DATE_DAY);
        this.ARRAY_DATE_HOUR = new BuiltinArrayBridge(this.DATE_HOUR);
        this.ARRAY_DATE_MINUTE = new BuiltinArrayBridge(this.DATE_MINUTE);
        this.ARRAY_DATE_SECOND = new BuiltinArrayBridge(this.DATE_SECOND);
        this.CALENDAR_YEAR = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_YEAR);
        this.CALENDAR_MONTH = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_MONTH);
        this.CALENDAR_DAY = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_DAY);
        this.CALENDAR_HOUR = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_HOUR);
        this.CALENDAR_MINUTE = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_MINUTE);
        this.CALENDAR_SECOND = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_SECOND);
        this.ITERABLE_CALENDAR_YEAR = new BuiltinIterableBridge(this.CALENDAR_YEAR);
        this.ITERABLE_CALENDAR_MONTH = new BuiltinIterableBridge(this.CALENDAR_MONTH);
        this.ITERABLE_CALENDAR_DAY = new BuiltinIterableBridge(this.CALENDAR_DAY);
        this.ITERABLE_CALENDAR_HOUR = new BuiltinIterableBridge(this.CALENDAR_HOUR);
        this.ITERABLE_CALENDAR_MINUTE = new BuiltinIterableBridge(this.CALENDAR_MINUTE);
        this.ITERABLE_CALENDAR_SECOND = new BuiltinIterableBridge(this.CALENDAR_SECOND);
        this.MAP_CALENDAR_YEAR = new BuiltinMapBridge(this.CALENDAR_YEAR);
        this.MAP_CALENDAR_MONTH = new BuiltinMapBridge(this.CALENDAR_MONTH);
        this.MAP_CALENDAR_DAY = new BuiltinMapBridge(this.CALENDAR_DAY);
        this.MAP_CALENDAR_HOUR = new BuiltinMapBridge(this.CALENDAR_HOUR);
        this.MAP_CALENDAR_MINUTE = new BuiltinMapBridge(this.CALENDAR_MINUTE);
        this.MAP_CALENDAR_SECOND = new BuiltinMapBridge(this.CALENDAR_SECOND);
        this.ARRAY_CALENDAR_YEAR = new BuiltinArrayBridge(this.CALENDAR_YEAR);
        this.ARRAY_CALENDAR_MONTH = new BuiltinArrayBridge(this.CALENDAR_MONTH);
        this.ARRAY_CALENDAR_DAY = new BuiltinArrayBridge(this.CALENDAR_DAY);
        this.ARRAY_CALENDAR_HOUR = new BuiltinArrayBridge(this.CALENDAR_HOUR);
        this.ARRAY_CALENDAR_MINUTE = new BuiltinArrayBridge(this.CALENDAR_MINUTE);
        this.ARRAY_CALENDAR_SECOND = new BuiltinArrayBridge(this.CALENDAR_SECOND);
        this.ITERABLE_BRIDGE = new BuiltinIterableBridge();
        this.ITERABLE_BRIDGE_DOUBLE = new BuiltinIterableBridge(NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        this.ITERABLE_BRIDGE_FLOAT = new BuiltinIterableBridge(NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        this.ITERABLE_BRIDGE_INT = new BuiltinIterableBridge(NumericFieldBridge.INT_FIELD_BRIDGE);
        this.ITERABLE_BRIDGE_LONG = new BuiltinIterableBridge(NumericFieldBridge.LONG_FIELD_BRIDGE);
        this.ARRAY_BRIDGE = new BuiltinArrayBridge();
        this.ARRAY_BRIDGE_DOUBLE = new BuiltinArrayBridge(NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        this.ARRAY_BRIDGE_FLOAT = new BuiltinArrayBridge(NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        this.ARRAY_BRIDGE_INT = new BuiltinArrayBridge(NumericFieldBridge.INT_FIELD_BRIDGE);
        this.ARRAY_BRIDGE_LONG = new BuiltinArrayBridge(NumericFieldBridge.LONG_FIELD_BRIDGE);
        this.MAP_BRIDGE = new BuiltinMapBridge();
        this.MAP_BRIDGE_DOUBLE = new BuiltinMapBridge(NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        this.MAP_BRIDGE_FLOAT = new BuiltinMapBridge(NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        this.MAP_BRIDGE_INT = new BuiltinMapBridge(NumericFieldBridge.INT_FIELD_BRIDGE);
        this.MAP_BRIDGE_LONG = new BuiltinMapBridge(NumericFieldBridge.LONG_FIELD_BRIDGE);
        this.DATE_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.DateBridge.DATE_MILLISECOND);
        this.ARRAY_DATE_MILLISECOND = new BuiltinArrayBridge(this.DATE_MILLISECOND);
        this.ITERABLE_DATE_MILLISECOND = new BuiltinIterableBridge(this.DATE_MILLISECOND);
        this.MAP_DATE_MILLISECOND = new BuiltinMapBridge(this.DATE_MILLISECOND);
        this.CALENDAR_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(CalendarBridge.CALENDAR_MILLISECOND);
        this.ARRAY_CALENDAR_MILLISECOND = new BuiltinArrayBridge(this.CALENDAR_MILLISECOND);
        this.ITERABLE_CALENDAR_MILLISECOND = new BuiltinIterableBridge(this.CALENDAR_MILLISECOND);
        this.MAP_CALENDAR_MILLISECOND = new BuiltinMapBridge(this.CALENDAR_MILLISECOND);
        this.builtInBridges = new HashMap<String, FieldBridge>();
        this.builtInBridges.put(Character.class.getName(), this.CHARACTER);
        this.builtInBridges.put(Character.TYPE.getName(), this.CHARACTER);
        this.builtInBridges.put(Double.class.getName(), this.DOUBLE);
        this.builtInBridges.put(Double.TYPE.getName(), this.DOUBLE);
        this.builtInBridges.put(Float.class.getName(), this.FLOAT);
        this.builtInBridges.put(Float.TYPE.getName(), this.FLOAT);
        this.builtInBridges.put(Short.class.getName(), this.SHORT);
        this.builtInBridges.put(Short.TYPE.getName(), this.SHORT);
        this.builtInBridges.put(Integer.class.getName(), this.INTEGER);
        this.builtInBridges.put(Integer.TYPE.getName(), this.INTEGER);
        this.builtInBridges.put(Long.class.getName(), this.LONG);
        this.builtInBridges.put(Long.TYPE.getName(), this.LONG);
        this.builtInBridges.put(BigInteger.class.getName(), this.BIG_INTEGER);
        this.builtInBridges.put(BigDecimal.class.getName(), this.BIG_DECIMAL);
        this.builtInBridges.put(String.class.getName(), this.STRING);
        this.builtInBridges.put(Boolean.class.getName(), this.BOOLEAN);
        this.builtInBridges.put(Boolean.TYPE.getName(), this.BOOLEAN);
        this.builtInBridges.put(Class.class.getName(), this.CLAZZ);
        this.builtInBridges.put(URL.class.getName(), this.Url);
        this.builtInBridges.put(URI.class.getName(), this.Uri);
        this.builtInBridges.put(UUID.class.getName(), this.UUID);
        this.builtInBridges.put(Date.class.getName(), this.DATE_MILLISECOND);
        this.builtInBridges.put(Calendar.class.getName(), this.CALENDAR_MILLISECOND);
        this.numericBridges = new HashMap<String, NumericFieldBridge>();
        this.numericBridges.put(Integer.class.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        this.numericBridges.put(Integer.TYPE.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        this.numericBridges.put(Long.class.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        this.numericBridges.put(Long.TYPE.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        this.numericBridges.put(Double.class.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        this.numericBridges.put(Double.TYPE.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        this.numericBridges.put(Float.class.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        this.numericBridges.put(Float.TYPE.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        this.numericMapBridges = new HashMap<String, BuiltinMapBridge>();
        this.numericMapBridges.put(Integer.class.getName(), this.MAP_BRIDGE_INT);
        this.numericMapBridges.put(Integer.TYPE.getName(), this.MAP_BRIDGE_INT);
        this.numericMapBridges.put(Long.class.getName(), this.MAP_BRIDGE_LONG);
        this.numericMapBridges.put(Long.TYPE.getName(), this.MAP_BRIDGE_LONG);
        this.numericMapBridges.put(Double.class.getName(), this.MAP_BRIDGE_DOUBLE);
        this.numericMapBridges.put(Double.TYPE.getName(), this.MAP_BRIDGE_DOUBLE);
        this.numericMapBridges.put(Float.class.getName(), this.MAP_BRIDGE_FLOAT);
        this.numericMapBridges.put(Float.TYPE.getName(), this.MAP_BRIDGE_FLOAT);
        this.numericArrayBridges = new HashMap<String, BuiltinArrayBridge>();
        this.numericArrayBridges.put(Integer.class.getName(), this.ARRAY_BRIDGE_INT);
        this.numericArrayBridges.put(Integer.TYPE.getName(), this.ARRAY_BRIDGE_INT);
        this.numericArrayBridges.put(Long.class.getName(), this.ARRAY_BRIDGE_LONG);
        this.numericArrayBridges.put(Long.TYPE.getName(), this.ARRAY_BRIDGE_LONG);
        this.numericArrayBridges.put(Double.class.getName(), this.ARRAY_BRIDGE_DOUBLE);
        this.numericArrayBridges.put(Double.TYPE.getName(), this.ARRAY_BRIDGE_DOUBLE);
        this.numericArrayBridges.put(Float.class.getName(), this.ARRAY_BRIDGE_FLOAT);
        this.numericArrayBridges.put(Float.TYPE.getName(), this.ARRAY_BRIDGE_FLOAT);
        this.numericIterableBridges = new HashMap<String, BuiltinIterableBridge>();
        this.numericIterableBridges.put(Integer.class.getName(), this.ITERABLE_BRIDGE_INT);
        this.numericIterableBridges.put(Integer.TYPE.getName(), this.ITERABLE_BRIDGE_INT);
        this.numericIterableBridges.put(Long.class.getName(), this.ITERABLE_BRIDGE_LONG);
        this.numericIterableBridges.put(Long.TYPE.getName(), this.ITERABLE_BRIDGE_LONG);
        this.numericIterableBridges.put(Double.class.getName(), this.ITERABLE_BRIDGE_DOUBLE);
        this.numericIterableBridges.put(Double.TYPE.getName(), this.ITERABLE_BRIDGE_DOUBLE);
        this.numericIterableBridges.put(Float.class.getName(), this.ITERABLE_BRIDGE_FLOAT);
        this.numericIterableBridges.put(Float.TYPE.getName(), this.ITERABLE_BRIDGE_FLOAT);
    }

    public FieldBridge extractType(ClassBridge cb, Class<?> clazz) {
        Class<?> bridgeType;
        FieldBridge bridge;
        block7: {
            bridge = null;
            bridgeType = null;
            if (cb != null && (bridgeType = cb.impl()) != null) {
                try {
                    Object instance = bridgeType.newInstance();
                    if (FieldBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = (FieldBridge)instance;
                        break block7;
                    }
                    if (TwoWayStringBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
                        break block7;
                    }
                    if (StringBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
                        break block7;
                    }
                    throw LOG.noFieldBridgeInterfaceImplementedByClassBridge(bridgeType.getName());
                }
                catch (Exception e) {
                    throw LOG.cannotInstantiateClassBridgeOfType(bridgeType.getName(), clazz.getName(), e);
                }
            }
        }
        if (bridge == null) {
            throw LOG.unableToDetermineClassBridge(ClassBridge.class.getName());
        }
        this.populateReturnType(clazz, bridgeType, bridge);
        return bridge;
    }

    public void injectParameters(ClassBridge classBridgeConfiguration, Object classBridge) {
        if (classBridgeConfiguration.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(classBridge.getClass())) {
            HashMap<String, String> params = new HashMap<String, String>(classBridgeConfiguration.params().length);
            for (Parameter param : classBridgeConfiguration.params()) {
                params.put(param.name(), param.value());
            }
            ((ParameterizedBridge)classBridge).setParameterValues(params);
        }
    }

    public FieldBridge buildSpatialBridge(Spatial spatial, XClass clazz, String latitudeField, String longitudeField) {
        FieldBridge bridge;
        try {
            bridge = this.buildSpatialBridge(spatial, latitudeField, longitudeField);
        }
        catch (Exception e) {
            throw LOG.unableToInstantiateSpatial(clazz.getName(), e);
        }
        if (bridge == null) {
            throw LOG.unableToInstantiateSpatial(clazz.getName(), null);
        }
        return bridge;
    }

    public FieldBridge buildSpatialBridge(Spatial spatial, XMember member) {
        FieldBridge bridge;
        try {
            bridge = this.buildSpatialBridge(spatial, null, null);
        }
        catch (Exception e) {
            throw LOG.unableToInstantiateSpatial(member.getName(), e);
        }
        if (bridge == null) {
            throw LOG.unableToInstantiateSpatial(member.getName(), null);
        }
        return bridge;
    }

    public FieldBridge buildSpatialBridge(Spatial spatial, String latitudeField, String longitudeField) {
        SpatialFieldBridge bridge = null;
        if (spatial != null) {
            bridge = spatial.spatialMode() == SpatialMode.HASH ? (latitudeField != null && longitudeField != null ? new SpatialFieldBridgeByHash(spatial.topSpatialHashLevel(), spatial.bottomSpatialHashLevel(), latitudeField, longitudeField) : new SpatialFieldBridgeByHash(spatial.topSpatialHashLevel(), spatial.bottomSpatialHashLevel())) : (latitudeField != null && longitudeField != null ? new SpatialFieldBridgeByRange(latitudeField, longitudeField) : new SpatialFieldBridgeByRange());
        }
        return bridge;
    }

    public FieldBridge guessType(Field field, NumericField numericField, XMember member, ReflectionManager reflectionManager, ServiceManager serviceManager) {
        FieldBridge bridge;
        org.hibernate.search.annotations.FieldBridge bridgeAnn = field != null && Void.TYPE != field.bridge().impl() ? field.bridge() : (org.hibernate.search.annotations.FieldBridge)member.getAnnotation(org.hibernate.search.annotations.FieldBridge.class);
        if (bridgeAnn != null) {
            bridge = this.doExtractType(bridgeAnn, member, reflectionManager);
        } else if (member.isAnnotationPresent(DateBridge.class)) {
            Resolution resolution = ((DateBridge)member.getAnnotation(DateBridge.class)).resolution();
            bridge = this.guessDateFieldBridge(member, reflectionManager, resolution);
        } else if (member.isAnnotationPresent(org.hibernate.search.annotations.CalendarBridge.class)) {
            Resolution resolution = ((org.hibernate.search.annotations.CalendarBridge)member.getAnnotation(org.hibernate.search.annotations.CalendarBridge.class)).resolution();
            bridge = this.guessCalendarFieldBridge(member, reflectionManager, resolution);
        } else if (member.isAnnotationPresent(TikaBridge.class)) {
            TikaBridge annotation = (TikaBridge)member.getAnnotation(TikaBridge.class);
            bridge = this.createTikaBridge(annotation, serviceManager);
        } else if (numericField != null) {
            bridge = this.guessNumericFieldBridge(member, reflectionManager);
        } else if (member.isAnnotationPresent(Spatial.class)) {
            Spatial spatialAnn = (Spatial)member.getAnnotation(Spatial.class);
            bridge = this.buildSpatialBridge(spatialAnn, member);
        } else {
            XClass returnType = member.getType();
            bridge = this.builtInBridges.get(returnType.getName());
            if (bridge == null && returnType.isEnum()) {
                EnumBridge enumBridge = new EnumBridge();
                this.populateReturnType(reflectionManager.toClass(member.getType()), EnumBridge.class, enumBridge);
                bridge = new TwoWayString2FieldBridgeAdaptor(enumBridge);
            }
            if (bridge == null && this.isAnnotatedWithIndexEmbedded(member)) {
                bridge = this.guessEmbeddedFieldBridge(member, reflectionManager);
            }
        }
        if (bridge == null) {
            throw LOG.unableToGuessFieldBridge(member.getType().getName(), member.getName());
        }
        return bridge;
    }

    private FieldBridge createTikaBridge(TikaBridge annotation, ServiceManager serviceManager) {
        Class<?> tikaParseContextProviderClass;
        FieldBridge tikaBridge;
        Class tikaBridgeClass;
        try {
            tikaBridgeClass = ClassLoaderHelper.classForName("org.hibernate.search.bridge.builtin.TikaBridge", serviceManager);
            tikaBridge = ClassLoaderHelper.instanceFromClass(FieldBridge.class, tikaBridgeClass, "Tika bridge");
        }
        catch (ClassLoadingException e) {
            throw new AssertionFailure("Unable to find Tika bridge class: org.hibernate.search.bridge.builtin.TikaBridge");
        }
        Class<?> tikaMetadataProcessorClass = annotation.metadataProcessor();
        if (tikaMetadataProcessorClass != Void.TYPE) {
            this.configureTikaBridgeParameters(tikaBridgeClass, "setMetadataProcessorClass", tikaBridge, tikaMetadataProcessorClass);
        }
        if ((tikaParseContextProviderClass = annotation.parseContextProvider()) != Void.TYPE) {
            this.configureTikaBridgeParameters(tikaBridgeClass, "setParseContextProviderClass", tikaBridge, tikaParseContextProviderClass);
        }
        return tikaBridge;
    }

    private void configureTikaBridgeParameters(Class<?> tikaBridgeClass, String setter, Object tikaBridge, Class<?> clazz) {
        try {
            Method m = tikaBridgeClass.getMethod(setter, Class.class);
            m.invoke(tikaBridge, clazz);
        }
        catch (Exception e) {
            throw LOG.unableToConfigureTikaBridge("org.hibernate.search.bridge.builtin.TikaBridge", e);
        }
    }

    private FieldBridge guessEmbeddedFieldBridge(XMember member, ReflectionManager reflectionManager) {
        if (this.isIterable(reflectionManager, member)) {
            return this.ITERABLE_BRIDGE;
        }
        if (member.isArray()) {
            return this.ARRAY_BRIDGE;
        }
        if (this.isMap(member)) {
            return this.MAP_BRIDGE;
        }
        return null;
    }

    private FieldBridge guessNumericFieldBridge(XMember member, ReflectionManager reflectionManager) {
        if (this.isNotAnnotatedWithIndexEmbedded(member)) {
            return this.numericBridges.get(member.getType().getName());
        }
        if (this.isIterable(reflectionManager, member)) {
            return this.numericIterableBridges.get(member.getElementClass().getName());
        }
        if (member.isArray()) {
            return this.numericArrayBridges.get(member.getElementClass().getName());
        }
        if (this.isMap(member)) {
            return this.numericMapBridges.get(member.getElementClass().getName());
        }
        return null;
    }

    private FieldBridge guessCalendarFieldBridge(XMember member, ReflectionManager reflectionManager, Resolution resolution) {
        if (this.isNotAnnotatedWithIndexEmbedded(member)) {
            return this.getCalendarField(resolution);
        }
        if (this.isIterable(reflectionManager, member)) {
            return this.getIterableCalendarField(resolution);
        }
        if (member.isArray()) {
            return this.getArrayCalendarField(resolution);
        }
        if (this.isMap(member)) {
            return this.getMapCalendarField(resolution);
        }
        return null;
    }

    private FieldBridge guessDateFieldBridge(XMember member, ReflectionManager reflectionManager, Resolution resolution) {
        if (this.isNotAnnotatedWithIndexEmbedded(member)) {
            return this.getDateField(resolution);
        }
        if (this.isIterable(reflectionManager, member)) {
            return this.getIterableDateField(resolution);
        }
        if (member.isArray()) {
            return this.getArrayDateField(resolution);
        }
        if (this.isMap(member)) {
            return this.getMapDateField(resolution);
        }
        return null;
    }

    private boolean isNotAnnotatedWithIndexEmbedded(XMember member) {
        return !this.isAnnotatedWithIndexEmbedded(member);
    }

    private boolean isAnnotatedWithIndexEmbedded(XMember member) {
        return member.isAnnotationPresent(IndexedEmbedded.class);
    }

    private boolean isIterable(ReflectionManager reflectionManager, XMember member) {
        Class typeClass = reflectionManager.toClass(member.getType());
        return Iterable.class.isAssignableFrom(typeClass);
    }

    private boolean isMap(XMember member) {
        return member.isCollection() && Map.class.equals((Object)member.getCollectionClass());
    }

    private FieldBridge doExtractType(org.hibernate.search.annotations.FieldBridge bridgeAnn, XMember member, ReflectionManager reflectionManager) {
        return this.doExtractType(bridgeAnn, member.getName(), reflectionManager.toClass(member.getType()));
    }

    private FieldBridge doExtractType(org.hibernate.search.annotations.FieldBridge bridgeAnn, String appliedOnName, Class<?> appliedOnType) {
        FieldBridge bridge;
        assert (bridgeAnn != null) : "@FieldBridge instance cannot be null";
        Class<?> impl = bridgeAnn.impl();
        if (impl == Void.TYPE) {
            throw LOG.noImplementationClassInFieldBridge(appliedOnName);
        }
        try {
            Object instance = impl.newInstance();
            if (FieldBridge.class.isAssignableFrom(impl)) {
                bridge = (FieldBridge)instance;
            } else if (TwoWayStringBridge.class.isAssignableFrom(impl)) {
                bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
            } else if (StringBridge.class.isAssignableFrom(impl)) {
                bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
            } else {
                throw LOG.noFieldBridgeInterfaceImplementedByFieldBridge(impl.getName(), appliedOnName);
            }
            if (bridgeAnn.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(impl)) {
                HashMap<String, String> params = new HashMap<String, String>(bridgeAnn.params().length);
                for (Parameter param : bridgeAnn.params()) {
                    params.put(param.name(), param.value());
                }
                ((ParameterizedBridge)instance).setParameterValues(params);
            }
            this.populateReturnType(appliedOnType, impl, instance);
        }
        catch (Exception e) {
            throw LOG.unableToInstantiateFieldBridge(appliedOnName, appliedOnType.getName(), e);
        }
        return bridge;
    }

    private void populateReturnType(Class<?> appliedOnType, Class<?> bridgeType, Object bridgeInstance) {
        if (AppliedOnTypeAwareBridge.class.isAssignableFrom(bridgeType)) {
            ((AppliedOnTypeAwareBridge)bridgeInstance).setAppliedOnType(appliedOnType);
        }
    }

    public FieldBridge getDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.DATE_YEAR;
            }
            case MONTH: {
                return this.DATE_MONTH;
            }
            case DAY: {
                return this.DATE_DAY;
            }
            case HOUR: {
                return this.DATE_HOUR;
            }
            case MINUTE: {
                return this.DATE_MINUTE;
            }
            case SECOND: {
                return this.DATE_SECOND;
            }
            case MILLISECOND: {
                return this.DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }

    public FieldBridge getArrayDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.ARRAY_DATE_YEAR;
            }
            case MONTH: {
                return this.ARRAY_DATE_MONTH;
            }
            case DAY: {
                return this.ARRAY_DATE_DAY;
            }
            case HOUR: {
                return this.ARRAY_DATE_HOUR;
            }
            case MINUTE: {
                return this.ARRAY_DATE_MINUTE;
            }
            case SECOND: {
                return this.ARRAY_DATE_SECOND;
            }
            case MILLISECOND: {
                return this.ARRAY_DATE_MILLISECOND;
            }
        }
        throw LOG.unknownArrayBridgeForResolution(resolution.toString());
    }

    public FieldBridge getMapDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.MAP_DATE_YEAR;
            }
            case MONTH: {
                return this.MAP_DATE_MONTH;
            }
            case DAY: {
                return this.MAP_DATE_DAY;
            }
            case HOUR: {
                return this.MAP_DATE_HOUR;
            }
            case MINUTE: {
                return this.MAP_DATE_MINUTE;
            }
            case SECOND: {
                return this.MAP_DATE_SECOND;
            }
            case MILLISECOND: {
                return this.MAP_DATE_MILLISECOND;
            }
        }
        throw LOG.unknownMapBridgeForResolution(resolution.toString());
    }

    public FieldBridge getIterableDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.ITERABLE_DATE_YEAR;
            }
            case MONTH: {
                return this.ITERABLE_DATE_MONTH;
            }
            case DAY: {
                return this.ITERABLE_DATE_DAY;
            }
            case HOUR: {
                return this.ITERABLE_DATE_HOUR;
            }
            case MINUTE: {
                return this.ITERABLE_DATE_MINUTE;
            }
            case SECOND: {
                return this.ITERABLE_DATE_SECOND;
            }
            case MILLISECOND: {
                return this.ITERABLE_DATE_MILLISECOND;
            }
        }
        throw LOG.unknownIterableBridgeForResolution(resolution.toString());
    }

    public FieldBridge getCalendarField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.CALENDAR_YEAR;
            }
            case MONTH: {
                return this.CALENDAR_MONTH;
            }
            case DAY: {
                return this.CALENDAR_DAY;
            }
            case HOUR: {
                return this.CALENDAR_HOUR;
            }
            case MINUTE: {
                return this.CALENDAR_MINUTE;
            }
            case SECOND: {
                return this.CALENDAR_SECOND;
            }
            case MILLISECOND: {
                return this.CALENDAR_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }

    public FieldBridge getArrayCalendarField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.ARRAY_CALENDAR_YEAR;
            }
            case MONTH: {
                return this.ARRAY_CALENDAR_MONTH;
            }
            case DAY: {
                return this.ARRAY_CALENDAR_DAY;
            }
            case HOUR: {
                return this.ARRAY_CALENDAR_HOUR;
            }
            case MINUTE: {
                return this.ARRAY_CALENDAR_MINUTE;
            }
            case SECOND: {
                return this.ARRAY_CALENDAR_SECOND;
            }
            case MILLISECOND: {
                return this.ARRAY_CALENDAR_MILLISECOND;
            }
        }
        throw LOG.unknownArrayBridgeForResolution(resolution.toString());
    }

    public FieldBridge getMapCalendarField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.MAP_CALENDAR_YEAR;
            }
            case MONTH: {
                return this.MAP_CALENDAR_MONTH;
            }
            case DAY: {
                return this.MAP_CALENDAR_DAY;
            }
            case HOUR: {
                return this.MAP_CALENDAR_HOUR;
            }
            case MINUTE: {
                return this.MAP_CALENDAR_MINUTE;
            }
            case SECOND: {
                return this.MAP_CALENDAR_SECOND;
            }
            case MILLISECOND: {
                return this.MAP_CALENDAR_MILLISECOND;
            }
        }
        throw LOG.unknownMapBridgeForResolution(resolution.toString());
    }

    public FieldBridge getIterableCalendarField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return this.ITERABLE_CALENDAR_YEAR;
            }
            case MONTH: {
                return this.ITERABLE_CALENDAR_MONTH;
            }
            case DAY: {
                return this.ITERABLE_CALENDAR_DAY;
            }
            case HOUR: {
                return this.ITERABLE_CALENDAR_HOUR;
            }
            case MINUTE: {
                return this.ITERABLE_CALENDAR_MINUTE;
            }
            case SECOND: {
                return this.ITERABLE_CALENDAR_SECOND;
            }
            case MILLISECOND: {
                return this.ITERABLE_CALENDAR_MILLISECOND;
            }
        }
        throw LOG.unknownIterableBridgeForResolution(resolution.toString());
    }

    public TwoWayFieldBridge extractTwoWayType(org.hibernate.search.annotations.FieldBridge fieldBridge, XClass appliedOnType, ReflectionManager reflectionManager) {
        FieldBridge fb = this.extractType(fieldBridge, appliedOnType, reflectionManager);
        if (fb instanceof TwoWayFieldBridge) {
            return (TwoWayFieldBridge)fb;
        }
        throw LOG.fieldBridgeNotAnInstanceof(TwoWayFieldBridge.class.getSimpleName());
    }

    public FieldBridge extractType(org.hibernate.search.annotations.FieldBridge fieldBridgeAnnotation, XClass appliedOnType, ReflectionManager reflectionManager) {
        FieldBridge bridge = null;
        if (fieldBridgeAnnotation != null) {
            bridge = this.doExtractType(fieldBridgeAnnotation, appliedOnType.getName(), reflectionManager.toClass(appliedOnType));
        }
        if (bridge == null) {
            throw LOG.unableToDetermineClassBridge(appliedOnType.getName());
        }
        return bridge;
    }
}

