/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TypeMetadata {
    private static final Log log = LoggerFactory.make();
    private static final String COMPONENT_PATH_SEPARATOR = ".";
    private final Class<?> indexedType;
    private final float boost;
    private final Discriminator discriminator;
    private final XMember discriminatorGetter;
    private final BoostStrategy classBoostStrategy;
    private final List<PropertyMetadata> propertyMetadata;
    private final Map<String, DocumentFieldMetadata> documentFieldNameToFieldMetadata;
    private final Map<String, PropertyMetadata> propertyGetterNameToPropertyMetadata;
    private final PropertyMetadata idPropertyMetadata;
    private final List<DocumentFieldMetadata> classBridgeFields;
    private final Map<String, DocumentFieldMetadata> classBridgeFieldNameToDocumentFieldMetadata;
    private final List<EmbeddedTypeMetadata> embeddedTypeMetadata;
    private final List<ContainedInMetadata> containedInMetadata;
    private final ScopedAnalyzer scopedAnalyzer;
    private boolean stateInspectionOptimizationsEnabled;
    private final List<String> collectionRoles;
    private final boolean jpaIdUsedAsDocumentId;
    private final Set<XClass> optimizationBlackList;

    protected TypeMetadata(Builder builder) {
        this.indexedType = builder.indexedType;
        this.boost = builder.boost;
        this.scopedAnalyzer = builder.scopedAnalyzer;
        this.scopedAnalyzer.setGlobalAnalyzer(builder.analyzer);
        this.discriminator = builder.discriminator;
        this.discriminatorGetter = builder.discriminatorGetter;
        this.classBoostStrategy = builder.classBoostStrategy;
        this.stateInspectionOptimizationsEnabled = builder.stateInspectionOptimizationsEnabled;
        this.idPropertyMetadata = builder.idPropertyMetadata;
        this.embeddedTypeMetadata = CollectionHelper.toImmutableList(builder.embeddedTypeMetadata);
        this.containedInMetadata = CollectionHelper.toImmutableList(builder.containedInMetadata);
        this.optimizationBlackList = Collections.unmodifiableSet(builder.optimizationClassList);
        this.collectionRoles = CollectionHelper.toImmutableList(builder.collectionRoles);
        this.jpaIdUsedAsDocumentId = this.determineWhetherDocumentIdPropertyIsTheSameAsJpaIdProperty(builder.jpaProperty);
        this.classBridgeFields = CollectionHelper.toImmutableList(builder.classBridgeFields);
        this.propertyMetadata = CollectionHelper.toImmutableList(builder.propertyMetadataList);
        this.propertyGetterNameToPropertyMetadata = this.keyPropertyMetadata(builder.propertyMetadataList);
        this.documentFieldNameToFieldMetadata = this.keyFieldMetadata(builder.propertyMetadataList);
        this.classBridgeFieldNameToDocumentFieldMetadata = this.copyClassBridgeMetadata(builder.classBridgeFields);
    }

    public Class<?> getType() {
        return this.indexedType;
    }

    public List<PropertyMetadata> getAllPropertyMetadata() {
        return this.propertyMetadata;
    }

    public PropertyMetadata getPropertyMetadataForProperty(String propertyName) {
        return this.propertyGetterNameToPropertyMetadata.get(propertyName);
    }

    public PropertyMetadata getIdPropertyMetadata() {
        return this.idPropertyMetadata;
    }

    public List<DocumentFieldMetadata> getClassBridgeMetadata() {
        return this.classBridgeFields;
    }

    public DocumentFieldMetadata getDocumentFieldMetadataFor(String fieldName) {
        DocumentFieldMetadata result = this.documentFieldNameToFieldMetadata.get(fieldName);
        if (result != null) {
            return result;
        }
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            result = element.getDocumentFieldMetadataFor(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection<DocumentFieldMetadata> getAllDocumentFieldMetadata() {
        if (this.embeddedTypeMetadata.isEmpty()) {
            return this.documentFieldNameToFieldMetadata.values();
        }
        ArrayList<DocumentFieldMetadata> allMetadata = new ArrayList<DocumentFieldMetadata>(this.documentFieldNameToFieldMetadata.size());
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            allMetadata.addAll(element.getAllDocumentFieldMetadata());
        }
        allMetadata.addAll(this.documentFieldNameToFieldMetadata.values());
        return allMetadata;
    }

    public List<EmbeddedTypeMetadata> getEmbeddedTypeMetadata() {
        return this.embeddedTypeMetadata;
    }

    public List<ContainedInMetadata> getContainedInMetadata() {
        return this.containedInMetadata;
    }

    public Collection<XClass> getOptimizationBlackList() {
        return this.optimizationBlackList;
    }

    public boolean containsCollectionRole(String role) {
        for (String knownRolls : this.collectionRoles) {
            if (!this.isSubRole(knownRolls, role)) continue;
            return true;
        }
        return false;
    }

    public boolean areClassBridgesUsed() {
        return !this.classBridgeFieldNameToDocumentFieldMetadata.isEmpty();
    }

    public DocumentFieldMetadata getFieldMetadataForClassBridgeField(String fieldName) {
        return this.classBridgeFieldNameToDocumentFieldMetadata.get(fieldName);
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public XMember getDiscriminatorGetter() {
        return this.discriminatorGetter;
    }

    public boolean areStateInspectionOptimizationsEnabled() {
        return this.stateInspectionOptimizationsEnabled;
    }

    public void disableStateInspectionOptimizations() {
        this.stateInspectionOptimizationsEnabled = false;
    }

    public LuceneOptions getClassLuceneOptions(DocumentFieldMetadata fieldMetadata, float documentLevelBoost) {
        return new LuceneOptionsImpl(fieldMetadata, 1.0f, documentLevelBoost);
    }

    public LuceneOptions getFieldLuceneOptions(PropertyMetadata propertyMetadata, DocumentFieldMetadata fieldMetadata, Object value, float documentBoost) {
        return new LuceneOptionsImpl(fieldMetadata, fieldMetadata.getBoost().floatValue() * propertyMetadata.getDynamicBoostStrategy().defineBoost(value), documentBoost);
    }

    public BoostStrategy getDynamicBoost() {
        return this.classBoostStrategy;
    }

    public float getStaticBoost() {
        return this.boost;
    }

    public float getClassBoost(Object value) {
        return this.boost * this.classBoostStrategy.defineBoost(value);
    }

    public ScopedAnalyzer getDefaultAnalyzer() {
        return this.scopedAnalyzer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TypeMetadata{");
        sb.append("boost=").append(this.boost);
        sb.append(", discriminator=").append(this.discriminator);
        sb.append(", discriminatorGetter=").append(this.discriminatorGetter);
        sb.append(", classBoostStrategy=").append(this.classBoostStrategy);
        sb.append(", documentFieldNameToFieldMetadata=").append(this.documentFieldNameToFieldMetadata);
        sb.append(", propertyGetterNameToFieldMetadata=").append(this.propertyGetterNameToPropertyMetadata);
        sb.append(", idPropertyMetadata=").append(this.idPropertyMetadata);
        sb.append(", classBridgeFields=").append(this.classBridgeFieldNameToDocumentFieldMetadata);
        sb.append(", embeddedTypeMetadata=").append(this.embeddedTypeMetadata);
        sb.append(", containedInMetadata=").append(this.containedInMetadata);
        sb.append(", optimizationBlackList=").append(this.optimizationBlackList);
        sb.append(", stateInspectionOptimizationsEnabled=").append(this.stateInspectionOptimizationsEnabled);
        sb.append(", scopedAnalyzer=").append((Object)this.scopedAnalyzer);
        sb.append(", collectionRoles=").append(this.collectionRoles);
        sb.append('}');
        return sb.toString();
    }

    private boolean isSubRole(String subRole, String role) {
        if (role.equals(subRole)) {
            return true;
        }
        return role.startsWith(subRole + COMPONENT_PATH_SEPARATOR);
    }

    private boolean determineWhetherDocumentIdPropertyIsTheSameAsJpaIdProperty(XProperty jpaIdProperty) {
        if (this.idPropertyMetadata == null) {
            return false;
        }
        if (jpaIdProperty == null) {
            return false;
        }
        return jpaIdProperty.equals(this.idPropertyMetadata.getPropertyAccessor());
    }

    private Map<String, PropertyMetadata> keyPropertyMetadata(Set<PropertyMetadata> propertyMetadataSet) {
        HashMap<String, PropertyMetadata> tmpMap = new HashMap<String, PropertyMetadata>();
        for (PropertyMetadata propertyMetadata : propertyMetadataSet) {
            tmpMap.put(propertyMetadata.getPropertyAccessorName(), propertyMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Map<String, DocumentFieldMetadata> keyFieldMetadata(Set<PropertyMetadata> propertyMetadataSet) {
        HashMap<String, DocumentFieldMetadata> tmpMap = new HashMap<String, DocumentFieldMetadata>();
        for (PropertyMetadata propertyMetadata : propertyMetadataSet) {
            for (DocumentFieldMetadata documentFieldMetadata : propertyMetadata.getFieldMetadata()) {
                DocumentFieldMetadata oldFieldMetadata = tmpMap.put(documentFieldMetadata.getName(), documentFieldMetadata);
                if (oldFieldMetadata == null || documentFieldMetadata.getIndex().equals((Object)oldFieldMetadata.getIndex())) continue;
                log.inconsistentFieldConfiguration(documentFieldMetadata.getName());
            }
        }
        for (DocumentFieldMetadata documentFieldMetadata : this.classBridgeFields) {
            tmpMap.put(documentFieldMetadata.getName(), documentFieldMetadata);
        }
        if (this.idPropertyMetadata != null) {
            for (DocumentFieldMetadata documentFieldMetadata : this.idPropertyMetadata.getFieldMetadata()) {
                tmpMap.put(documentFieldMetadata.getName(), documentFieldMetadata);
            }
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Map<String, DocumentFieldMetadata> copyClassBridgeMetadata(Set<DocumentFieldMetadata> classBridgeFields) {
        HashMap<String, DocumentFieldMetadata> tmpMap = new HashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata fieldMetadata : classBridgeFields) {
            tmpMap.put(fieldMetadata.getName(), fieldMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    public boolean isJpaIdUsedAsDocumentId() {
        return this.jpaIdUsedAsDocumentId;
    }

    public static class Builder {
        private final Class<?> indexedType;
        private final ScopedAnalyzer scopedAnalyzer;
        private final PassThroughAnalyzer passThroughAnalyzer;
        private float boost;
        private BoostStrategy classBoostStrategy;
        private Analyzer analyzer;
        private Discriminator discriminator;
        private XMember discriminatorGetter;
        private boolean stateInspectionOptimizationsEnabled = true;
        private Set<PropertyMetadata> propertyMetadataList = new HashSet<PropertyMetadata>();
        private Set<DocumentFieldMetadata> classBridgeFields = new HashSet<DocumentFieldMetadata>();
        private Set<EmbeddedTypeMetadata> embeddedTypeMetadata = new HashSet<EmbeddedTypeMetadata>();
        private Set<ContainedInMetadata> containedInMetadata = new HashSet<ContainedInMetadata>();
        private Set<XClass> optimizationClassList = new HashSet<XClass>();
        private Set<String> collectionRoles = new TreeSet<String>();
        private PropertyMetadata idPropertyMetadata;
        private XProperty jpaProperty;

        public Builder(Class<?> indexedType, ConfigContext configContext) {
            this(indexedType, configContext, new ScopedAnalyzer());
        }

        public Builder(Class<?> indexedType, ConfigContext configContext, ScopedAnalyzer scopedAnalyzer) {
            this.indexedType = indexedType;
            this.scopedAnalyzer = scopedAnalyzer;
            this.passThroughAnalyzer = PassThroughAnalyzer.INSTANCE;
        }

        public Builder idProperty(PropertyMetadata propertyMetadata) {
            this.idPropertyMetadata = propertyMetadata;
            return this;
        }

        public Builder boost(float boost) {
            this.boost = boost;
            return this;
        }

        public Builder boostStrategy(BoostStrategy boostStrategy) {
            this.classBoostStrategy = boostStrategy;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder jpaProperty(XProperty jpaProperty) {
            this.jpaProperty = jpaProperty;
            return this;
        }

        public Builder analyzerDiscriminator(Discriminator discriminator, XMember discriminatorGetter) {
            if (this.discriminator != null) {
                throw new SearchException("Multiple AnalyzerDiscriminator defined in the same class hierarchy: " + this.indexedType.getName());
            }
            this.discriminator = discriminator;
            this.discriminatorGetter = discriminatorGetter;
            return this;
        }

        public Builder addProperty(PropertyMetadata propertyMetadata) {
            this.propertyMetadataList.add(propertyMetadata);
            return this;
        }

        public void addClassBridgeField(DocumentFieldMetadata fieldMetadata) {
            this.classBridgeFields.add(fieldMetadata);
        }

        public void addEmbeddedType(EmbeddedTypeMetadata embeddedTypeMetadata) {
            this.embeddedTypeMetadata.add(embeddedTypeMetadata);
        }

        public void addContainedIn(ContainedInMetadata containedInMetadata) {
            this.containedInMetadata.add(containedInMetadata);
        }

        public void addCollectionRole(String role) {
            this.collectionRoles.add(role);
        }

        public void disableStateInspectionOptimization() {
            this.stateInspectionOptimizationsEnabled = false;
        }

        public Analyzer addToScopedAnalyzer(String fieldName, Analyzer analyzer, Field.Index index) {
            if (analyzer == null) {
                analyzer = this.getAnalyzer();
            }
            if (Field.Index.ANALYZED.equals((Object)index) || Field.Index.ANALYZED_NO_NORMS.equals((Object)index)) {
                if (analyzer != null) {
                    this.scopedAnalyzer.addScopedAnalyzer(fieldName, analyzer);
                }
            } else {
                this.scopedAnalyzer.addScopedAnalyzer(fieldName, this.passThroughAnalyzer);
            }
            return analyzer;
        }

        public void blacklistForOptimization(XClass blackListClass) {
            this.optimizationClassList.add(blackListClass);
        }

        public boolean areClassBridgesUsed() {
            return !this.classBridgeFields.isEmpty();
        }

        public BoostStrategy getClassBoostStrategy() {
            return this.classBoostStrategy;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public ScopedAnalyzer getScopedAnalyzer() {
            return this.scopedAnalyzer;
        }

        public boolean isStateInspectionOptimizationsEnabled() {
            return this.stateInspectionOptimizationsEnabled;
        }

        public Class<?> getIndexedType() {
            return this.indexedType;
        }

        public TypeMetadata build() {
            return new TypeMetadata(this);
        }

        public String toString() {
            return "TypeMetadata.Builder{indexedType=" + this.indexedType + "}";
        }
    }
}

