/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.SearchException;

public final class NumericFieldUtils {
    private NumericFieldUtils() {
    }

    public static Query createNumericRangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Class<Number> numericClass;
        if (from != null) {
            numericClass = from.getClass();
        } else if (to != null) {
            numericClass = to.getClass();
        } else {
            throw new SearchException("Cannot create numeric range query for field " + fieldName + ", since from and to values are " + "null");
        }
        if (numericClass.isAssignableFrom(Double.class)) {
            return NumericRangeQuery.newDoubleRange((String)fieldName, (Double)((Double)from), (Double)((Double)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Long.class)) {
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)((Long)from), (Long)((Long)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Integer.class)) {
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)((Integer)from), (Integer)((Integer)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Float.class)) {
            return NumericRangeQuery.newFloatRange((String)fieldName, (Float)((Float)from), (Float)((Float)to), (boolean)includeLower, (boolean)includeUpper);
        }
        throw new SearchException("Cannot create numeric range query for field " + fieldName + ", since values are not numeric " + "(int,long, short or double) ");
    }

    public static Query createExactMatchQuery(String fieldName, Object value) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, value, value, true, true);
    }
}

