/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class BackendFactory {
    private static final Log log = LoggerFactory.make();
    private static final String JMS_BACKEND_QUEUE_PROCESSOR = "org.hibernate.search.backend.jms.impl.JndiJMSBackendQueueProcessor";
    private static final String JGROUPS_BACKEND_QUEUE_PROCESSOR = "org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueProcessor";
    private static final String JGROUPS_MASTER_SELECTOR = "org.hibernate.search.backend.jgroups.impl.MasterNodeSelector";
    private static final String JGROUPS_SLAVE_SELECTOR = "org.hibernate.search.backend.jgroups.impl.SlaveNodeSelector";
    private static final String JGROUPS_AUTO_SELECTOR = "org.hibernate.search.backend.jgroups.impl.AutoNodeSelector";
    private static final String JGROUPS_SELECTOR_BASE_TYPE = "org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy";

    private BackendFactory() {
    }

    public static BackendQueueProcessor createBackend(DirectoryBasedIndexManager indexManager, WorkerBuildContext buildContext, Properties properties) {
        String backend = properties.getProperty("worker.backend");
        return BackendFactory.createBackend(backend, indexManager, buildContext, properties);
    }

    public static BackendQueueProcessor createBackend(String backend, DirectoryBasedIndexManager indexManager, WorkerBuildContext buildContext, Properties properties) {
        BackendQueueProcessor backendQueueProcessor;
        if (StringHelper.isEmpty(backend) || "lucene".equalsIgnoreCase(backend)) {
            backendQueueProcessor = new LuceneBackendQueueProcessor();
        } else if ("jms".equalsIgnoreCase(backend)) {
            backendQueueProcessor = ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, JMS_BACKEND_QUEUE_PROCESSOR, "JMS backend ", buildContext.getServiceManager());
        } else if ("blackhole".equalsIgnoreCase(backend)) {
            backendQueueProcessor = new BlackHoleBackendQueueProcessor();
        } else if ("jgroupsMaster".equals(backend)) {
            backendQueueProcessor = BackendFactory.createJGroupsQueueProcessor(JGROUPS_MASTER_SELECTOR, buildContext);
        } else if ("jgroupsSlave".equals(backend)) {
            backendQueueProcessor = BackendFactory.createJGroupsQueueProcessor(JGROUPS_SLAVE_SELECTOR, buildContext);
        } else if ("jgroups".equals(backend)) {
            Object autoNodeSelector;
            Class<?> selectorClass = ClassLoaderHelper.classForName(JGROUPS_AUTO_SELECTOR, "JGroups node selector ", buildContext.getServiceManager());
            try {
                Constructor<?> constructor = selectorClass.getConstructor(String.class);
                autoNodeSelector = constructor.newInstance(indexManager.getIndexName());
            }
            catch (Exception e) {
                throw log.getUnableToCreateJGroupsBackendException(e);
            }
            backendQueueProcessor = BackendFactory.createJGroupsQueueProcessor(autoNodeSelector, buildContext.getServiceManager());
        } else {
            ServiceManager serviceManager = buildContext.getServiceManager();
            backendQueueProcessor = ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, backend, "processor", serviceManager);
        }
        backendQueueProcessor.initialize(properties, buildContext, indexManager);
        return backendQueueProcessor;
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("worker.execution"));
    }

    public static ExecutorService buildWorkersExecutor(Properties properties, String indexManagerName) {
        int threadPoolSize = BackendFactory.getWorkerThreadPoolSize(properties);
        int queueSize = BackendFactory.getWorkerQueueSize(properties);
        return Executors.newFixedThreadPool(threadPoolSize, "IndexWriter worker executor for " + indexManagerName, queueSize);
    }

    public static int getWorkerThreadPoolSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.thread_pool.size", 1);
    }

    public static int getWorkerQueueSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.buffer_queue.max", Integer.MAX_VALUE);
    }

    private static BackendQueueProcessor createJGroupsQueueProcessor(String selectorClass, BuildContext buildContext) {
        ServiceManager serviceManager = buildContext.getServiceManager();
        return BackendFactory.createJGroupsQueueProcessor(ClassLoaderHelper.instanceFromName(Object.class, selectorClass, "JGroups node selector", serviceManager), serviceManager);
    }

    private static BackendQueueProcessor createJGroupsQueueProcessor(Object selectorInstance, ServiceManager serviceManager) {
        BackendQueueProcessor backendQueueProcessor;
        Class<?> processorClass = ClassLoaderHelper.classForName(JGROUPS_BACKEND_QUEUE_PROCESSOR, "JGroups backend ", serviceManager);
        Class<?> selectorClass = ClassLoaderHelper.classForName(JGROUPS_SELECTOR_BASE_TYPE, "JGroups node selector ", serviceManager);
        try {
            Constructor<?> constructor = processorClass.getConstructor(selectorClass);
            backendQueueProcessor = (BackendQueueProcessor)constructor.newInstance(selectorInstance);
        }
        catch (Exception e) {
            throw log.getUnableToCreateJGroupsBackendException(e);
        }
        return backendQueueProcessor;
    }
}

