/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.CacheFromIndex;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.fieldcache.impl.ClassLoadingStrategySelector;
import org.hibernate.search.query.fieldcache.impl.FieldCacheLoadingType;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DocumentBuilderIndexedEntity
extends AbstractDocumentBuilder {
    private static final Log log = LoggerFactory.make();
    private static final LuceneOptions NULL_EMBEDDED_MARKER_OPTIONS;
    private boolean allowFieldSelectionInProjection = false;
    private boolean idProvided;
    private final Set<FieldCacheType> fieldCacheUsage;
    private final String identifierName;
    private final FieldCacheCollectorFactory idFieldCacheCollectorFactory;
    private final String idFieldName;
    private PropertyMetadata idPropertyMetadata;

    public DocumentBuilderIndexedEntity(XClass clazz, TypeMetadata typeMetadata, ConfigContext context, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        super(clazz, typeMetadata, reflectionManager, optimizationBlackList, instanceInitializer);
        ProvidedId providedIdAnnotation = this.findProvidedId(clazz, reflectionManager);
        if (providedIdAnnotation != null || context.isProvidedIdImplicit()) {
            this.idProvided = true;
        }
        if (this.idPropertyMetadata == null) {
            this.idPropertyMetadata = this.getTypeMetadata().getIdPropertyMetadata();
        }
        if (this.idPropertyMetadata == null) {
            throw log.noDocumentIdFoundException(clazz.getName());
        }
        this.idFieldName = this.idPropertyMetadata.getFieldMetadata().iterator().next().getName();
        CacheFromIndex fieldCacheOptions = (CacheFromIndex)clazz.getAnnotation(CacheFromIndex.class);
        if (fieldCacheOptions == null) {
            this.fieldCacheUsage = Collections.unmodifiableSet(EnumSet.of(FieldCacheType.CLASS));
        } else {
            EnumSet<FieldCacheType> enabledTypes = EnumSet.noneOf(FieldCacheType.class);
            Collections.addAll(enabledTypes, fieldCacheOptions.value());
            if (enabledTypes.size() != 1 && enabledTypes.contains((Object)FieldCacheType.NOTHING)) {
                throw new SearchException("CacheFromIndex configured with conflicting parameters: if FieldCacheType.NOTHING is enabled, no other options can be added");
            }
            this.fieldCacheUsage = Collections.unmodifiableSet(enabledTypes);
        }
        this.checkAllowFieldSelection();
        this.idFieldCacheCollectorFactory = this.figureIdFieldCacheUsage();
        if (log.isDebugEnabled()) {
            log.debugf("Field selection in projections is set to %b for entity %s.", this.allowFieldSelectionInProjection, clazz);
        }
        this.entityState = EntityState.INDEXED;
        this.identifierName = this.idProvided ? null : this.idPropertyMetadata.getPropertyAccessor().getName();
    }

    private FieldCacheCollectorFactory figureIdFieldCacheUsage() {
        if (this.fieldCacheUsage.contains((Object)FieldCacheType.ID)) {
            FieldCacheLoadingType collectorTypeForId = ClassLoadingStrategySelector.guessAppropriateCollectorType(this.getIdBridge());
            if (collectorTypeForId == null) {
                log.cannotExtractValueForIdentifier(this.getBeanClass());
                return null;
            }
            TwoWayStringBridge twoWayIdStringBridge = ClassLoadingStrategySelector.getTwoWayStringBridge(this.getIdBridge());
            return new FieldCacheCollectorFactory(this.getIdKeywordName(), collectorTypeForId, twoWayIdStringBridge);
        }
        return null;
    }

    public XMember getIdGetter() {
        return this.idPropertyMetadata.getPropertyAccessor();
    }

    public FieldCacheCollectorFactory getIdFieldCacheCollectionFactory() {
        return this.idFieldCacheCollectorFactory;
    }

    private ProvidedId findProvidedId(XClass clazz, ReflectionManager reflectionManager) {
        ProvidedId id = null;
        XClass currentClass = clazz;
        while (id == null && !reflectionManager.equals(currentClass, Object.class)) {
            id = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
            currentClass = currentClass.getSuperclass();
        }
        return id;
    }

    @Override
    public void addWorkToQueue(Class<?> entityClass, Object entity, Serializable id, boolean delete, boolean add, List<LuceneWork> queue, ConversionContext contextualBridge) {
        DocumentFieldMetadata idFieldMetadata = this.idPropertyMetadata.getFieldMetadata(this.idFieldName);
        String idInString = this.objectToString(this.getIdBridge(), idFieldMetadata.getName(), (Object)id, contextualBridge);
        if (delete && !add) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (add && !delete) {
            queue.add(this.createAddWork(entityClass, entity, id, idInString, this.getInstanceInitializer(), contextualBridge));
        } else if (add && delete) {
            queue.add(this.createUpdateWork(entityClass, entity, id, idInString, this.getInstanceInitializer(), contextualBridge));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(TwoWayFieldBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).twoWayConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(StringBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).stringConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    public AddLuceneWork createAddWork(Class<?> entityClass, Object entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext conversionContext) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap, sessionInitializer, conversionContext, null);
        AddLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new AddLuceneWork(id, idInString, entityClass, doc) : new AddLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    public UpdateLuceneWork createUpdateWork(Class entityClass, Object entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext contextualBridge) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap, sessionInitializer, contextualBridge, null);
        UpdateLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new UpdateLuceneWork(id, idInString, entityClass, doc) : new UpdateLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(Object instance, Serializable id, Map<String, String> fieldToAnalyzerMap, InstanceInitializer objectInitializer, ConversionContext conversionContext, String[] includedFieldNames) {
        if (fieldToAnalyzerMap == null) {
            throw new IllegalArgumentException("fieldToAnalyzerMap cannot be null");
        }
        if (objectInitializer == null) {
            objectInitializer = this.getInstanceInitializer();
        }
        Document doc = new Document();
        Class<Object> entityType = objectInitializer.getClass(instance);
        float documentLevelBoost = this.getMetadata().getClassBoost(instance);
        if (this.containsFieldName("_hibernate_class", includedFieldNames)) {
            Field classField = new Field("_hibernate_class", entityType.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
            doc.add((IndexableField)classField);
        }
        if (this.containsFieldName(this.idFieldName, includedFieldNames)) {
            DocumentFieldMetadata idFieldMetaData = this.idPropertyMetadata.getFieldMetadata(this.idFieldName);
            LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(idFieldMetaData, idFieldMetaData.getBoost().floatValue(), documentLevelBoost);
            FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(this.getIdBridge());
            conversionContext.setClass(entityType);
            conversionContext.pushProperty(idFieldMetaData.getName());
            try {
                contextualizedBridge.set(idFieldMetaData.getName(), id, doc, luceneOptions);
            }
            finally {
                conversionContext.popProperty();
            }
        }
        HashSet<String> processedFieldNames = new HashSet<String>();
        this.buildDocumentFields(instance, doc, this.getMetadata(), fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentLevelBoost);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildDocumentFields(Object instance, Document doc, TypeMetadata typeMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, ConversionContext conversionContext, InstanceInitializer objectInitializer, float documentBoost) {
        unproxiedInstance = this.unproxy(instance, objectInitializer);
        for (DocumentFieldMetadata fieldMetadata : typeMetadata.getClassBridgeMetadata()) {
            fieldBridge = fieldMetadata.getFieldBridge();
            fieldName = fieldMetadata.getName();
            oneWayConversionContext = conversionContext.oneWayConversionContext(fieldBridge);
            conversionContext.pushProperty(fieldName);
            try {
                oneWayConversionContext.set(fieldName, unproxiedInstance, doc, typeMetadata.getClassLuceneOptions(fieldMetadata, documentBoost));
            }
            finally {
                conversionContext.popProperty();
            }
        }
        previousMember = null;
        currentFieldValue = null;
        for (PropertyMetadata propertyMetadata : typeMetadata.getAllPropertyMetadata()) {
            member = propertyMetadata.getPropertyAccessor();
            if (previousMember != member) {
                currentFieldValue = this.unproxy(ReflectionHelper.getMemberValue(unproxiedInstance, (XMember)member), objectInitializer);
                previousMember = member;
                if (member.isCollection()) {
                    if (currentFieldValue instanceof Collection) {
                        objectInitializer.initializeCollection((Collection)currentFieldValue);
                    } else if (currentFieldValue instanceof Map) {
                        objectInitializer.initializeMap((Map)currentFieldValue);
                    }
                }
            }
            try {
                conversionContext.pushProperty(propertyMetadata.getPropertyAccessorName());
                for (DocumentFieldMetadata fieldMetadata : propertyMetadata.getFieldMetadata()) {
                    fieldBridge = fieldMetadata.getFieldBridge();
                    fieldName = fieldMetadata.getName();
                    oneWayConversionContext = conversionContext.oneWayConversionContext(fieldBridge);
                    oneWayConversionContext.set(fieldName, currentFieldValue, doc, typeMetadata.getFieldLuceneOptions(propertyMetadata, fieldMetadata, currentFieldValue, documentBoost));
                }
            }
            finally {
                conversionContext.popProperty();
            }
        }
        this.allowAnalyzerDiscriminatorOverride(doc, typeMetadata, fieldToAnalyzerMap, processedFieldNames, unproxiedInstance);
lbl45:
        // 7 sources

        block19: for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            member = embeddedTypeMetadata.getEmbeddedGetter();
            conversionContext.pushProperty(embeddedTypeMetadata.getEmbeddedFieldName());
            try {
                value = ReflectionHelper.getMemberValue(unproxiedInstance, (XMember)member);
                if (value == null) {
                    this.processEmbeddedNullValue(doc, embeddedTypeMetadata, conversionContext);
                    continue;
                }
                switch (1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[embeddedTypeMetadata.getEmbeddedContainer().ordinal()]) {
                    case 1: {
                        for (Object arrayValue : array = objectInitializer.initializeArray((Object[])value)) {
                            this.buildDocumentFields(arrayValue, doc, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentBoost);
                        }
                        continue block19;
                    }
                    case 2: {
                        collection = objectInitializer.initializeCollection((Collection)value);
                        for (T collectionValue : collection) {
                            this.buildDocumentFields(collectionValue, doc, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentBoost);
                        }
                        continue block19;
                    }
                    case 3: {
                        map = objectInitializer.initializeMap((Map)value);
                        for (V collectionValue : map.values()) {
                            this.buildDocumentFields(collectionValue, doc, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentBoost);
                        }
                        continue block19;
                    }
                    case 4: {
                        this.buildDocumentFields(value, doc, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentBoost);
                        ** break;
                    }
                    default: {
                        throw new AssertionFailure("Unknown embedded container: " + (Object)embeddedTypeMetadata.getEmbeddedContainer());
                    }
                }
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    private boolean containsFieldName(String value, String[] array) {
        if (array == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (String containedValue : array) {
            if (!value.equals(containedValue)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEmbeddedNullValue(Document doc, EmbeddedTypeMetadata embeddedTypeMetadata, ConversionContext conversionContext) {
        String nullMarker = embeddedTypeMetadata.getEmbeddedNullToken();
        if (nullMarker != null) {
            String fieldName = embeddedTypeMetadata.getEmbeddedNullFieldName();
            FieldBridge fieldBridge = embeddedTypeMetadata.getEmbeddedNullFieldBridge();
            FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(fieldBridge);
            conversionContext.pushProperty(fieldName);
            try {
                contextualizedBridge.set(fieldName, null, doc, NULL_EMBEDDED_MARKER_OPTIONS);
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    private Object unproxy(Object instance, InstanceInitializer objectInitializer) {
        if (instance == null) {
            return null;
        }
        return objectInitializer.unproxy(instance);
    }

    private void allowAnalyzerDiscriminatorOverride(Document doc, TypeMetadata typeMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, Object unproxiedInstance) {
        Discriminator discriminator = typeMetadata.getDiscriminator();
        if (discriminator == null) {
            return;
        }
        Object value = null;
        if (typeMetadata.getDiscriminatorGetter() != null) {
            value = ReflectionHelper.getMemberValue(unproxiedInstance, typeMetadata.getDiscriminatorGetter());
        }
        for (IndexableField field : doc.getFields()) {
            if (processedFieldNames.contains(field.name())) continue;
            String analyzerName = discriminator.getAnalyzerDefinitionName(value, unproxiedInstance, field.name());
            if (analyzerName != null) {
                fieldToAnalyzerMap.put(field.name(), analyzerName);
            }
            processedFieldNames.add(field.name());
        }
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public boolean allowFieldSelectionInProjection() {
        return this.allowFieldSelectionInProjection;
    }

    public Set<FieldCacheType> getFieldCacheOption() {
        return this.fieldCacheUsage;
    }

    public TwoWayFieldBridge getIdBridge() {
        return (TwoWayFieldBridge)this.idPropertyMetadata.getFieldMetadata(this.idFieldName).getFieldBridge();
    }

    public String getIdKeywordName() {
        return this.idPropertyMetadata.getFieldMetadata(this.idFieldName).getName();
    }

    @Override
    public Serializable getId(Object entity) {
        if (entity == null || this.idPropertyMetadata.getPropertyAccessorName() == null || this.idProvided) {
            throw new IllegalStateException("Cannot guess id from entity");
        }
        Object unproxiedEntity = this.getInstanceInitializer().unproxy(entity);
        return (Serializable)ReflectionHelper.getMemberValue(unproxiedEntity, (XMember)this.idPropertyMetadata.getPropertyAccessor());
    }

    public String objectToString(String fieldName, Object value, ConversionContext conversionContext) {
        TwoWayFieldBridge bridge;
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        DocumentFieldMetadata idFieldMetaData = this.idPropertyMetadata.getFieldMetadata(this.idFieldName);
        FieldBridge fieldBridge = bridge = fieldName.equals(idFieldMetaData.getName()) ? this.getIdBridge() : this.getBridge(this.getMetadata(), fieldName);
        if (bridge != null) {
            return this.objectToString(fieldName, bridge, value, conversionContext);
        }
        throw new SearchException("Unable to find field " + fieldName + " in " + this.getBeanXClass());
    }

    public String objectToString(String fieldName, FieldBridge bridge, Object value, ConversionContext conversionContext) {
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        if (bridge == null) {
            throw new AssertionFailure("Field bridge should not be null");
        }
        Class<?> bridgeClass = bridge.getClass();
        if (TwoWayFieldBridge.class.isAssignableFrom(bridgeClass)) {
            return this.objectToString((TwoWayFieldBridge)bridge, fieldName, value, conversionContext);
        }
        if (StringBridge.class.isAssignableFrom(bridgeClass)) {
            return this.objectToString((StringBridge)((Object)bridge), fieldName, value, conversionContext);
        }
        throw log.fieldBridgeNotTwoWay(bridgeClass, fieldName, this.getBeanXClass());
    }

    private FieldBridge getNullBridge(EmbeddedTypeMetadata embeddedTypeMetadata, String fieldName) {
        if (fieldName.equals(embeddedTypeMetadata.getEmbeddedNullFieldName())) {
            return embeddedTypeMetadata.getEmbeddedNullFieldBridge();
        }
        return null;
    }

    public FieldBridge getBridge(String fieldName) {
        return this.getBridge(this.getMetadata(), fieldName);
    }

    private FieldBridge getBridge(TypeMetadata typeMetadata, String fieldName) {
        FieldBridge fieldBridge;
        DocumentFieldMetadata documentFieldMetadata = typeMetadata.getDocumentFieldMetadataFor(fieldName);
        if (documentFieldMetadata != null && documentFieldMetadata.getFieldBridge() != null) {
            return documentFieldMetadata.getFieldBridge();
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            fieldBridge = this.getBridge(embeddedTypeMetadata, fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            fieldBridge = this.getNullBridge(embeddedTypeMetadata, fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        DocumentFieldMetadata fieldMetadata = typeMetadata.getFieldMetadataForClassBridgeField(fieldName);
        fieldBridge = fieldMetadata == null ? null : fieldMetadata.getFieldBridge();
        return fieldBridge;
    }

    private void checkAllowFieldSelection() {
        this.allowFieldSelectionInProjection = true;
        if (!(this.getIdBridge() instanceof TwoWayStringBridge || this.getIdBridge() instanceof TwoWayString2FieldBridgeAdaptor || this.getIdBridge() instanceof NumericFieldBridge)) {
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (PropertyMetadata propertyMetadata : this.getMetadata().getAllPropertyMetadata()) {
            for (DocumentFieldMetadata documentFieldMetadata : propertyMetadata.getFieldMetadata()) {
                FieldBridge bridge = documentFieldMetadata.getFieldBridge();
                if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor || bridge instanceof NumericFieldBridge) continue;
                this.allowFieldSelectionInProjection = false;
                return;
            }
        }
        for (DocumentFieldMetadata fieldMetadata : this.getMetadata().getClassBridgeMetadata()) {
            FieldBridge bridge = fieldMetadata.getFieldBridge();
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor || bridge instanceof NumericFieldBridge) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
    }

    @Override
    public boolean requiresProvidedId() {
        return this.idProvided;
    }

    @Override
    public boolean isIdMatchingJpaId() {
        return !this.idProvided && this.getTypeMetadata().isJpaIdUsedAsDocumentId();
    }

    static {
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(null, Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build();
        NULL_EMBEDDED_MARKER_OPTIONS = new LuceneOptionsImpl(fieldMetadata, 1.0f, 1.0f);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container;

        static {
            $SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container = new int[EmbeddedTypeMetadata.Container.values().length];
            try {
                1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[EmbeddedTypeMetadata.Container.ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[EmbeddedTypeMetadata.Container.COLLECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[EmbeddedTypeMetadata.Container.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[EmbeddedTypeMetadata.Container.OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

