/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.bridge.impl.XMemberToAnnotatedElementAdaptor;
import org.hibernate.search.engine.service.spi.ServiceManager;

public class XMemberBridgeProviderContext
implements ExtendedBridgeProvider.ExtendedBridgeProviderContext {
    private final AnnotatedElement annotatedElement;
    private final Class<?> returnTypeElement;
    private final String memberName;
    private final ServiceManager serviceManager;
    private final NumericField numericField;

    public XMemberBridgeProviderContext(XMember member, NumericField numericField, ReflectionManager reflectionManager, ServiceManager serviceManager) {
        this.annotatedElement = new XMemberToAnnotatedElementAdaptor(member);
        this.returnTypeElement = reflectionManager.toClass(member.getElementClass());
        this.memberName = member.getName();
        this.serviceManager = serviceManager;
        this.numericField = numericField;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnTypeElement;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public NumericField getNumericField() {
        return this.numericField;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }
}

