/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LuceneBackendResources {
    private static final Log log = LoggerFactory.make();
    private final LuceneWorkVisitor visitor;
    private final AbstractWorkspaceImpl workspace;
    private final ErrorHandler errorHandler;
    private final ExecutorService queueingExecutor;
    private final int maxQueueLength;
    private final String indexName;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    LuceneBackendResources(WorkerBuildContext context, DirectoryBasedIndexManager indexManager, Properties props, AbstractWorkspaceImpl workspace) {
        this.indexName = indexManager.getIndexName();
        this.errorHandler = context.getErrorHandler();
        this.workspace = workspace;
        this.visitor = new LuceneWorkVisitor(workspace);
        this.maxQueueLength = PropertiesParseHelper.extractMaxQueueSize(this.indexName, props);
        this.queueingExecutor = Executors.newFixedThreadPool(1, "Index updates queue processor for index " + this.indexName, this.maxQueueLength);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    private LuceneBackendResources(LuceneBackendResources previous) {
        this.indexName = previous.indexName;
        this.errorHandler = previous.errorHandler;
        this.workspace = previous.workspace;
        this.visitor = new LuceneWorkVisitor(this.workspace);
        this.maxQueueLength = previous.maxQueueLength;
        this.queueingExecutor = previous.queueingExecutor;
        this.readLock = previous.readLock;
        this.writeLock = previous.writeLock;
    }

    public ExecutorService getQueueingExecutor() {
        return this.queueingExecutor;
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public LuceneWorkVisitor getVisitor() {
        return this.visitor;
    }

    public AbstractWorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.flushCloseExecutor(this.queueingExecutor);
        }
        finally {
            this.workspace.shutDownNow();
        }
    }

    private void flushCloseExecutor(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(e);
            Thread.currentThread().interrupt();
        }
        if (!executor.isTerminated()) {
            log.unableToShutdownAsynchronousIndexingByTimeout(this.indexName);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Lock getParallelModificationLock() {
        return this.readLock;
    }

    public Lock getExclusiveModificationLock() {
        return this.writeLock;
    }

    public LuceneBackendResources onTheFlyRebuild() {
        return new LuceneBackendResources(this);
    }
}

