/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class CalendarBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();
    private static final FieldBridge CALENDAR_YEAR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_YEAR);
    private static final FieldBridge CALENDAR_MONTH = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_MONTH);
    private static final FieldBridge CALENDAR_DAY = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_DAY);
    private static final FieldBridge CALENDAR_HOUR = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_HOUR);
    private static final FieldBridge CALENDAR_MINUTE = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_MINUTE);
    private static final FieldBridge CALENDAR_SECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_SECOND);
    static final FieldBridge CALENDAR_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(org.hibernate.search.bridge.builtin.CalendarBridge.CALENDAR_MILLISECOND);

    CalendarBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (annotatedElement.isAnnotationPresent(CalendarBridge.class)) {
            Resolution resolution = annotatedElement.getAnnotation(CalendarBridge.class).resolution();
            return this.getCalendarField(resolution);
        }
        return null;
    }

    private FieldBridge getCalendarField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return CALENDAR_YEAR;
            }
            case MONTH: {
                return CALENDAR_MONTH;
            }
            case DAY: {
                return CALENDAR_DAY;
            }
            case HOUR: {
                return CALENDAR_HOUR;
            }
            case MINUTE: {
                return CALENDAR_MINUTE;
            }
            case SECOND: {
                return CALENDAR_SECOND;
            }
            case MILLISECOND: {
                return CALENDAR_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }
}

