/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.batch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.StreamingSelectionVisitor;
import org.hibernate.search.backend.impl.TransactionalSelectionVisitor;
import org.hibernate.search.backend.impl.WorkQueuePerIndexSplitter;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.IndexShardingStrategy;

public class DefaultBatchBackend
implements BatchBackend {
    private final SearchIntegrator searchFactoryImplementor;
    private final MassIndexerProgressMonitor progressMonitor;

    public DefaultBatchBackend(SearchIntegrator searchFactoryImplementor, MassIndexerProgressMonitor progressMonitor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.sendWorkToShards(work, true);
    }

    @Override
    public void doWorkInSync(LuceneWork work) {
        this.sendWorkToShards(work, false);
    }

    private void sendWorkToShards(LuceneWork work, boolean forceAsync) {
        Class<?> entityType = work.getEntityClass();
        EntityIndexBinding entityIndexBinding = this.searchFactoryImplementor.getIndexBinding(entityType);
        IndexShardingStrategy shardingStrategy = entityIndexBinding.getSelectionStrategy();
        if (forceAsync) {
            work.getWorkDelegate(StreamingSelectionVisitor.INSTANCE).performStreamOperation(work, shardingStrategy, this.progressMonitor, forceAsync);
        } else {
            WorkQueuePerIndexSplitter workContext = new WorkQueuePerIndexSplitter();
            work.getWorkDelegate(TransactionalSelectionVisitor.INSTANCE).performOperation(work, shardingStrategy, workContext);
            workContext.commitOperations(this.progressMonitor);
        }
    }

    @Override
    public void flush(Set<Class<?>> entityTypes) {
        Collection<IndexManager> uniqueIndexManagers = this.uniqueIndexManagerForTypes(entityTypes);
        for (IndexManager indexManager : uniqueIndexManagers) {
            indexManager.performStreamOperation(FlushLuceneWork.INSTANCE, this.progressMonitor, false);
        }
    }

    @Override
    public void optimize(Set<Class<?>> entityTypes) {
        Collection<IndexManager> uniqueIndexManagers = this.uniqueIndexManagerForTypes(entityTypes);
        for (IndexManager indexManager : uniqueIndexManagers) {
            indexManager.performStreamOperation(OptimizeLuceneWork.INSTANCE, this.progressMonitor, false);
        }
    }

    private Collection<IndexManager> uniqueIndexManagerForTypes(Collection<Class<?>> entityTypes) {
        HashMap<String, IndexManager> uniqueBackends = new HashMap<String, IndexManager>(entityTypes.size());
        for (Class<?> type : entityTypes) {
            IndexManager[] indexManagers;
            EntityIndexBinding indexBindingForEntity = this.searchFactoryImplementor.getIndexBinding(type);
            if (indexBindingForEntity == null) continue;
            for (IndexManager im : indexManagers = indexBindingForEntity.getIndexManagers()) {
                uniqueBackends.put(im.getIndexName(), im);
            }
        }
        return uniqueBackends.values();
    }
}

