/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.concurrent.locks.LockSupport;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.Changeset;
import org.hibernate.search.backend.impl.lucene.ChangesetList;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.MultiWriteDrainableLinkedList;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchSyncProcessor {
    private static final Log log = LoggerFactory.make();
    private final MultiWriteDrainableLinkedList<Changeset> transferQueue = new MultiWriteDrainableLinkedList();
    private volatile LuceneBackendResources resources;
    private final String indexName;
    private volatile boolean stop = false;
    final Thread consumerThread;

    public BatchSyncProcessor(LuceneBackendResources resources, String indexName) {
        this.resources = resources;
        this.indexName = indexName;
        this.consumerThread = new Thread((Runnable)new Consumer(), "Hibernate Search sync consumer thread for index " + indexName);
        this.consumerThread.setDaemon(true);
    }

    public void start() {
        log.startingSyncConsumerThread(this.indexName);
        this.consumerThread.start();
    }

    public void submit(List<LuceneWork> workList, IndexingMonitor monitor) {
        Changeset changeset = new Changeset(workList, Thread.currentThread(), monitor);
        this.transferQueue.add(changeset);
        this.wakeUpConsumer();
        boolean interrupted = false;
        while (!changeset.isProcessed() && !interrupted) {
            this.parkCurrentThread();
            if (!Thread.interrupted()) continue;
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void wakeUpConsumer() {
        LockSupport.unpark(this.consumerThread);
    }

    public void shutdown() {
        this.stop = true;
        LockSupport.unpark(this.consumerThread);
    }

    void updateResources(LuceneBackendResources resources) {
        this.resources = resources;
    }

    private void parkCurrentThread() {
        LockSupport.parkNanos(1000000000L);
    }

    private class Consumer
    implements Runnable {
        private Consumer() {
        }

        @Override
        public void run() {
            while (!BatchSyncProcessor.this.stop) {
                Iterable<Changeset> changesets = BatchSyncProcessor.this.transferQueue.drainToDetachedIterable();
                while (changesets == null && !BatchSyncProcessor.this.stop) {
                    BatchSyncProcessor.this.parkCurrentThread();
                    changesets = BatchSyncProcessor.this.transferQueue.drainToDetachedIterable();
                }
                if (changesets == null) continue;
                this.applyChangesets(changesets);
            }
            log.stoppingSyncConsumerThread(BatchSyncProcessor.this.indexName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyChangesets(Iterable<Changeset> changesets) {
            ChangesetList changesetList = new ChangesetList(changesets);
            try {
                LuceneBackendQueueTask luceneBackendQueueTask = new LuceneBackendQueueTask(changesetList, BatchSyncProcessor.this.resources, null);
                luceneBackendQueueTask.run();
            }
            finally {
                changesetList.markProcessed();
            }
        }
    }
}

