/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;

class NumericBridgeProvider
extends ExtendedBridgeProvider {
    private static final Map<String, NumericFieldBridge> numericBridges = new HashMap<String, NumericFieldBridge>();

    NumericBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext bridgeContext) {
        if (bridgeContext.getNumericField() != null) {
            return numericBridges.get(bridgeContext.getReturnType().getName());
        }
        return null;
    }

    static {
        numericBridges.put(Integer.class.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        numericBridges.put(Integer.TYPE.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        numericBridges.put(Long.class.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        numericBridges.put(Long.TYPE.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        numericBridges.put(Double.class.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        numericBridges.put(Double.TYPE.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        numericBridges.put(Float.class.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        numericBridges.put(Float.TYPE.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
    }
}

