/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import org.apache.avro.Protocol;
import org.hibernate.search.indexes.serialization.avro.impl.ProtocolBuilderV1_0;
import org.hibernate.search.indexes.serialization.avro.impl.ProtocolBuilderV1_1;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class KnownProtocols {
    static final int MAJOR_VERSION = 1;
    static final int LATEST_MINOR_VERSION = 1;
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private volatile Protocol v1_0 = null;
    private volatile Protocol v1_1 = null;
    private volatile boolean warned = false;

    KnownProtocols() {
    }

    Protocol getProtocol(int majorVersion, int minorVersion) {
        if (1 != majorVersion) {
            throw log.incompatibleProtocolVersion(majorVersion, minorVersion, 1, 1);
        }
        if (minorVersion == 1) {
            return this.getV1_1();
        }
        if (minorVersion == 0) {
            return this.getV1_0();
        }
        if (!this.warned) {
            this.warned = true;
            log.unexpectedMinorProtocolVersion(majorVersion, minorVersion, 1);
        }
        return this.getV1_1();
    }

    Protocol getLatestProtocol() {
        return this.getProtocol(1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getV1_0() {
        Protocol p = this.v1_0;
        if (p == null) {
            KnownProtocols knownProtocols = this;
            synchronized (knownProtocols) {
                p = this.v1_0;
                if (p != null) {
                    return p;
                }
                this.v1_0 = p = new ProtocolBuilderV1_0().build();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getV1_1() {
        Protocol p = this.v1_1;
        if (p == null) {
            KnownProtocols knownProtocols = this;
            synchronized (knownProtocols) {
                p = this.v1_1;
                if (p != null) {
                    return p;
                }
                this.v1_1 = p = new ProtocolBuilderV1_1().build();
            }
        }
        return p;
    }
}

