/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class DeleteByQueryWorkExecutor
implements LuceneWorkExecutor {
    private static final Log log = LoggerFactory.make();
    protected final Workspace workspace;

    DeleteByQueryWorkExecutor(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        DeleteByQueryLuceneWork deleteWork = (DeleteByQueryLuceneWork)work;
        Class<?> entityType = work.getEntityClass();
        DeletionQuery query = deleteWork.getDeletionQuery();
        if (log.isTraceEnabled()) {
            log.tracef("Removing all %s matching Query: %s", entityType.toString(), query.toString());
        }
        BooleanQuery entityDeletionQuery = new BooleanQuery();
        ScopedAnalyzer analyzer = this.workspace.getDocumentBuilder(entityType).getAnalyzer();
        Query queryToDelete = query.toLuceneQuery(analyzer);
        entityDeletionQuery.add(queryToDelete, BooleanClause.Occur.MUST);
        Term classNameQueryTerm = new Term("_hibernate_class", entityType.getName());
        TermQuery classNameQuery = new TermQuery(classNameQueryTerm);
        entityDeletionQuery.add((Query)classNameQuery, BooleanClause.Occur.MUST);
        this.addTenantQueryTerm(work.getTenantId(), entityDeletionQuery);
        try {
            writer.deleteDocuments(new Query[]{entityDeletionQuery});
        }
        catch (IOException e) {
            SearchException ex = log.unableToDeleteByQuery(entityType, query, e);
            throw ex;
        }
        this.workspace.notifyWorkApplied(work);
    }

    private void addTenantQueryTerm(String tenantId, BooleanQuery entityDeletionQuery) {
        if (tenantId != null) {
            Term tenantTerm = new Term("__HSearch_TenantId", tenantId);
            entityDeletionQuery.add((Query)new TermQuery(tenantTerm), BooleanClause.Occur.MUST);
        }
    }
}

