/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;
    private float scoreSum;
    private float scoreMax;

    DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, Scorer[] subScorers) {
        super(weight, subScorers);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    protected void reset() {
        this.scoreMax = 0.0f;
        this.scoreSum = 0.0f;
    }

    @Override
    protected void accum(Scorer subScorer) throws IOException {
        float subScore = subScorer.score();
        this.scoreSum += subScore;
        if (subScore > this.scoreMax) {
            this.scoreMax = subScore;
        }
    }

    @Override
    protected float getFinal() {
        return this.scoreMax + (this.scoreSum - this.scoreMax) * this.tieBreakerMultiplier;
    }
}

