/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import io.searchbox.core.search.sort.Sort;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.spatial.Coordinates;

public class DistanceSort
extends Sort {
    private static final String GEO_DISTANCE_FIELD = "_geo_distance";
    private Coordinates center;
    private String fieldName;

    public DistanceSort(String fieldName, Coordinates center, Sort.Sorting order) {
        super(GEO_DISTANCE_FIELD, order);
        this.fieldName = fieldName;
        this.center = center;
    }

    public Map<String, Object> toMap() {
        Map rootMap = super.toMap();
        Map innerMap = (Map)rootMap.get(GEO_DISTANCE_FIELD);
        HashMap<String, Double> location = new HashMap<String, Double>(3);
        location.put("lat", this.center.getLatitude());
        location.put("lon", this.center.getLongitude());
        innerMap.put(this.fieldName, location);
        innerMap.put("unit", "km");
        innerMap.put("distance_type", "arc");
        return rootMap;
    }
}

