/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.ElasticsearchJsonQueryDescriptor;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.LuceneQueryTranslator;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.CollectionHelper;

public class ElasticsearchLuceneQueryTranslator
implements LuceneQueryTranslator,
Startable {
    private ExtendedSearchIntegrator extendedIntegrator;

    public void start(Properties properties, BuildContext context) {
        this.extendedIntegrator = context.getUninitializedSearchIntegrator();
    }

    public QueryDescriptor convertLuceneQuery(Query luceneQuery) {
        JsonObject convertedQuery = ToElasticsearch.fromLuceneQuery(luceneQuery);
        JsonObject query = new JsonObject();
        query.add("query", (JsonElement)convertedQuery);
        return new ElasticsearchJsonQueryDescriptor(query);
    }

    public boolean conversionRequired(Class<?> ... entities) {
        Set<Class<?>> queriedEntityTypes = this.getQueriedEntityTypes(entities);
        Set queriedEntityTypesWithSubTypes = this.extendedIntegrator.getIndexedTypesPolymorphic(queriedEntityTypes.toArray(new Class[queriedEntityTypes.size()]));
        for (Class queriedEntityType : queriedEntityTypesWithSubTypes) {
            IndexManager[] indexManagers;
            EntityIndexBinding binding = this.extendedIntegrator.getIndexBinding(queriedEntityType);
            if (binding == null) continue;
            for (IndexManager indexManager : indexManagers = binding.getIndexManagers()) {
                if (!(indexManager instanceof ElasticsearchIndexManager)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Class<?>> getQueriedEntityTypes(Class<?> ... indexedTargetedEntities) {
        if (indexedTargetedEntities == null || indexedTargetedEntities.length == 0) {
            return this.extendedIntegrator.getIndexBindings().keySet();
        }
        return CollectionHelper.asSet((Object[])indexedTargetedEntities);
    }
}

