/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.nesting.impl.NestingContext;
import org.hibernate.search.engine.nesting.impl.NestingContextFactory;
import org.hibernate.search.engine.nesting.impl.NestingContextFactoryProvider;
import org.hibernate.search.engine.nesting.impl.NoOpNestingContext;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;

public class ElasticsearchNestingContextFactoryProvider
implements NestingContextFactoryProvider,
Startable {
    private ElasticsearchNestingContextFactory factory;

    public void start(Properties properties, BuildContext context) {
        this.factory = new ElasticsearchNestingContextFactory(context.getUninitializedSearchIntegrator());
    }

    public NestingContextFactory getNestingContextFactory() {
        return this.factory;
    }

    private static class NestingStackElement {
        String field;
        Integer index;

        public NestingStackElement(String fieldName, Integer index) {
            this.field = fieldName;
            this.index = index;
        }

        public String toString() {
            if (this.index == null) {
                return this.field;
            }
            return this.field + "[" + this.index + "]";
        }

        void increment() {
            this.index = this.index + 1;
        }
    }

    private static class ElasticsearchNestingContext
    implements NestingContext {
        private Deque<NestingStackElement> path = new ArrayDeque<NestingStackElement>();

        private ElasticsearchNestingContext() {
        }

        public void push(String fieldName, EmbeddedTypeMetadata.Container containerType) {
            this.path.push(new NestingStackElement(fieldName, containerType == EmbeddedTypeMetadata.Container.OBJECT ? null : Integer.valueOf(0)));
        }

        public void mark(Document document) {
            String currentPath = StringHelper.join(this.path.descendingIterator(), (String)".");
            document.add((IndexableField)new TextField("$nesting", currentPath, Field.Store.NO));
        }

        public void incrementCollectionIndex() {
            this.path.peek().increment();
        }

        public void pop() {
            this.path.pop();
        }
    }

    private static enum ContextCreationStrategy {
        NO_OP{

            @Override
            NestingContext create() {
                return NoOpNestingContext.INSTANCE;
            }
        }
        ,
        ES{

            @Override
            NestingContext create() {
                return new ElasticsearchNestingContext();
            }
        };


        abstract NestingContext create();
    }

    private static class ElasticsearchNestingContextFactory
    implements NestingContextFactory {
        private final ConcurrentMap<String, ContextCreationStrategy> strategies = new ConcurrentHashMap<String, ContextCreationStrategy>();
        private ExtendedSearchIntegrator searchIntegrator;

        public ElasticsearchNestingContextFactory(ExtendedSearchIntegrator searchIntegrator) {
            this.searchIntegrator = searchIntegrator;
        }

        public NestingContext createNestingContext(Class<?> indexedEntityType) {
            ContextCreationStrategy strategy = (ContextCreationStrategy)((Object)this.strategies.get(indexedEntityType.getName()));
            if (strategy == null) {
                strategy = this.isMappedToElasticsearch(indexedEntityType) ? ContextCreationStrategy.ES : ContextCreationStrategy.NO_OP;
                this.strategies.putIfAbsent(indexedEntityType.getName(), strategy);
            }
            return strategy.create();
        }

        private boolean isMappedToElasticsearch(Class<?> entityType) {
            Set queriedEntityTypesWithSubTypes = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{entityType});
            for (Class queriedEntityType : queriedEntityTypesWithSubTypes) {
                IndexManager[] indexManagers;
                EntityIndexBinding binding = this.searchIntegrator.getIndexBinding(queriedEntityType);
                for (IndexManager indexManager : indexManagers = binding.getIndexManagers()) {
                    if (!(indexManager instanceof ElasticsearchIndexManager)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

