/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor;
import org.hibernate.search.bridge.builtin.time.impl.DurationBridge;
import org.hibernate.search.bridge.builtin.time.impl.InstantBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.MonthDayBridge;
import org.hibernate.search.bridge.builtin.time.impl.OffsetDateTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.OffsetTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.PeriodBridge;
import org.hibernate.search.bridge.builtin.time.impl.YearBridge;
import org.hibernate.search.bridge.builtin.time.impl.YearMonthBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZoneIdBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZoneOffsetBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZonedDateTimeBridge;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JavaTimeBridgeProvider
implements BridgeProvider {
    private static final Log LOG = LoggerFactory.make();
    private static final boolean ACTIVATED = JavaTimeBridgeProvider.javaTimePackageExists();
    private final Map<String, FieldBridge> builtInBridges = JavaTimeBridgeProvider.isActive() ? JavaTimeBridgeProvider.populateBridgeMap() : Collections.emptyMap();

    JavaTimeBridgeProvider() {
    }

    private static Map<String, FieldBridge> populateBridgeMap() {
        HashMap<String, FieldBridge> bridges = new HashMap<String, FieldBridge>(12);
        bridges.put(Year.class.getName(), YearBridge.INSTANCE);
        bridges.put(YearMonth.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(YearMonthBridge.INSTANCE));
        bridges.put(MonthDay.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(MonthDayBridge.INSTANCE));
        bridges.put(LocalDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(LocalDateTimeBridge.INSTANCE));
        bridges.put(LocalDate.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(LocalDateBridge.INSTANCE));
        bridges.put(LocalTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(LocalTimeBridge.INSTANCE));
        bridges.put(OffsetDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(OffsetDateTimeBridge.INSTANCE));
        bridges.put(OffsetTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(OffsetTimeBridge.INSTANCE));
        bridges.put(ZonedDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(ZonedDateTimeBridge.INSTANCE));
        bridges.put(ZoneOffset.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(ZoneOffsetBridge.INSTANCE));
        bridges.put(ZoneId.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(ZoneIdBridge.INSTANCE));
        bridges.put(Period.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor(PeriodBridge.INSTANCE));
        bridges.put(Duration.class.getName(), DurationBridge.INSTANCE);
        bridges.put(Instant.class.getName(), InstantBridge.INSTANCE);
        return bridges;
    }

    public static boolean isActive() {
        return ACTIVATED;
    }

    private static boolean javaTimePackageExists() {
        try {
            Class.forName("java.time.LocalDate");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.javaTimeBridgeWontBeAdded(e);
            return false;
        }
    }

    @Override
    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext bridgeProviderContext) {
        return this.builtInBridges.get(bridgeProviderContext.getReturnType().getName());
    }
}

